#ifndef __STA_MODULE_H__
#define __STA_MODULE_H__

#ifndef IS_BROADCAST_MAC
#define IS_BROADCAST_MAC(x)		( (*(UINT8*)x == 0xFF) 				\
									&& (*(UINT8*)(x+1) == 0xFF)		\
									&& (*(UINT8*)(x+2) == 0xFF)		\
									&& (*(UINT8*)(x+3) == 0xFF)		\
									&& (*(UINT8*)(x+4) == 0xFF)		\
									&& (*(UINT8*)(x+5) == 0xFF) )
#endif

#ifndef IS_MULTICAST_MAC							
#define IS_MULTICAST_MAC(x)		(*(UINT8*)x & 0x01) 
#endif

#ifndef IS_ZERO_MAC
#define IS_ZERO_MAC(x)			((*(UINT8*)x == 0) 				\
									&& (*(UINT8*)(x+1) == 0)	\
									&& (*(UINT8*)(x+2) == 0)	\
									&& (*(UINT8*)(x+3) == 0)	\
									&& (*(UINT8*)(x+4) == 0)	\
									&& (*(UINT8*)(x+5) == 0) )
#endif

#ifndef IS_EQUAL_MAC		
#define IS_EQUAL_MAC(x, y)		( 	((*(UINT8*)x) == (*(UINT8*)y))					\
									&& ((*(UINT8*)(x+1)) == (*(UINT8*)(y+1)))		\
									&& ((*(UINT8*)(x+2)) == (*(UINT8*)(y+2)))		\
									&& ((*(UINT8*)(x+3)) == (*(UINT8*)(y+3)))		\
									&& ((*(UINT8*)(x+4)) == (*(UINT8*)(y+4)))		\
									&& ((*(UINT8*)(x+5)) == (*(UINT8*)(y+5)))	)
#endif

#ifndef COPY_MAC
#define COPY_MAC(x, y)			 	((*(UINT8*)x) = (*(UINT8*)y));				\
									((*(UINT8*)(x+1)) = (*(UINT8*)(y+1)));		\
									((*(UINT8*)(x+2)) = (*(UINT8*)(y+2)));		\
									((*(UINT8*)(x+3)) = (*(UINT8*)(y+3)));		\
									((*(UINT8*)(x+4)) = (*(UINT8*)(y+4)));		\
									((*(UINT8*)(x+5)) = (*(UINT8*)(y+5)));	
#endif

#ifndef BIT_31
#define BIT_31   0x80000000
#endif
#ifndef BIT_30
#define BIT_30   0x40000000
#endif
#ifndef BIT_29
#define BIT_29   0x20000000
#endif
#ifndef BIT_28
#define BIT_28   0x10000000
#endif
#ifndef BIT_27
#define BIT_27   0x08000000
#endif
#ifndef BIT_26
#define BIT_26   0x04000000
#endif
#ifndef BIT_25
#define BIT_25   0x02000000
#endif
#ifndef BIT_24
#define BIT_24   0x01000000
#endif
#ifndef BIT_23
#define BIT_23   0x00800000
#endif
#ifndef BIT_22
#define BIT_22   0x00400000
#endif
#ifndef BIT_21
#define BIT_21   0x00200000
#endif
#ifndef BIT_20
#define BIT_20   0x00100000
#endif
#ifndef BIT_19
#define BIT_19   0x00080000
#endif
#ifndef BIT_18
#define BIT_18   0x00040000
#endif
#ifndef BIT_17
#define BIT_17   0x00020000
#endif
#ifndef BIT_16
#define BIT_16   0x00010000
#endif
#ifndef BIT_15
#define BIT_15   0x00008000
#endif
#ifndef BIT_14
#define BIT_14   0x00004000
#endif
#ifndef BIT_13
#define BIT_13   0x00002000
#endif
#ifndef BIT_12
#define BIT_12   0x00001000
#endif
#ifndef BIT_11
#define BIT_11   0x00000800
#endif
#ifndef BIT_10
#define BIT_10   0x00000400
#endif
#ifndef BIT_9
#define BIT_9    0x00000200
#endif
#ifndef BIT_8
#define BIT_8    0x00000100
#endif
#ifndef BIT_7
#define BIT_7    0x00000080
#endif
#ifndef BIT_6
#define BIT_6    0x00000040
#endif
#ifndef BIT_5
#define BIT_5    0x00000020
#endif
#ifndef BIT_4
#define BIT_4    0x00000010
#endif
#ifndef BIT_3
#define BIT_3    0x00000008
#endif
#ifndef BIT_2
#define BIT_2    0x00000004
#endif
#ifndef BIT_1
#define BIT_1    0x00000002
#endif
#ifndef BIT_0
#define BIT_0    0x00000001
#endif

#ifndef UINT8
#define UINT8	unsigned char
#endif
#ifndef UINT16
#define UINT16	unsigned short
#endif
#ifndef UINT32
#define UINT32	unsigned long
#endif

#ifndef TRUE
#define TRUE	1
#endif
#ifndef FALSE
#define FALSE	0
#endif

//define for Antenna
#ifndef ANTENNA_A
#define ANTENNA_A			1
#endif
#ifndef ANTENNA_B
#define ANTENNA_B			2
#endif
#ifndef ANTENNA_D
#define ANTENNA_D			3
#endif

//defined for Revesion
//#define VERSION_AA			0x10
//#define VERSION_AB			0x11
//#define VERSION_BA			0x20
/*Jeffrey01062003*/
#define REVISION_AB     0x11 //rywu06082002
#define REVISION_AF     0x15
#define REVISION_BA     0x20 //axl11072002 for ADM8211B

/* SRAM */
#define SIZE_OF_SRAM_A					512			//512*16
#define A_SHARE_KEY_1					0x160
#define A_SHARE_KEY_2					0x167
#define A_SHARE_KEY_3					0x16E
#define A_SHARE_KEY_4					0x175
#define A_SSID_IN_SRAM					0x0180
#define A_SUPPORT_RATE_IN_SRAM			0x0191

#define SIZE_OF_SRAM_B					448			//448*32
#define B_SHARE_KEY_1					0xc0		//192
#define B_SHARE_KEY_2					0xc5		//197
#define B_SHARE_KEY_3					0xca		//202
#define B_SHARE_KEY_4					0xcf		//207
#define B_SSID_IN_SRAM					0xd4		//212
#define B_SUPPORT_RATE_IN_SRAM			0xdd		//221
#define B_ATM_ADDR0_IN_SRAM				0xe4		//228
#define B_ATM_ADDR1_IN_SRAM				0x132		//306

#define STA_MDL_TX_PKT_SIZE		512

//const UINT8 BROADCASTADDR[] = {0xff,0xff,0xff,0xff,0xff,0xff};

/* Current Action (used in MDL_Current_Action) */
#define IN_INITIAL							0x00
#define	IN_LISTEN							0x01
#define	IN_ASSOCIATION						0x02
#define	IN_REASSOCIATION					0x03
#define	IN_PROBE							0x04
#define	IN_SCAN_CHANNEL						0x05
#define	IN_LISTEN_DESIGNATED_CHANNEL		0x06
#define	IN_AUTHENTICATION_A1				0x07 //axl01292002
#define	IN_AUTHENTICATION_A2				0x08
#define	IN_AUTHENTICATION_A3				0x09
#define	IN_AUTHENTICATION_A4				0x0A
#define	IN_ADHOC_LISTEN_BEACON				0x0B //rywu05072002
#define	IN_WAIT_FOR_LINK_ON					0x0C //rywu05092002
#define IN_ADHOC_WAIT_RSP					0x0D
#define	ALL_COMPLETE						0x10

#define MAX_AP_NUM							20

//method to select AP from channel scan
#define BY_SSID								0
#define BY_CHANNEL							1

#define AUTHENTICATION_RETRY_MAX_TIMES		4
#define	ASSOCIATION_RETRY_MAX_TIMES			3
#define REASSOCIATION_RETRY_MAX_TIMES		3

//OID value define
#define OID_802_11_BSSID	    			0x0D010101
#define OID_802_11_SSID						0x0D010102
#define OID_802_11_NETWORK_TYPES_SUPPORTED	0x0D010203
#define OID_802_11_NETWORK_TYPE_IN_USE		0x0D010204
#define OID_802_11_TX_POWER_LEVEL			0x0D010205
#define OID_802_11_RSSI						0x0D010206
#define OID_802_11_RSSI_TRIGGER				0x0D010207
#define OID_802_11_INFRASTRUCTURE_MODE		0x0D010108
#define OID_802_11_FRAGMENTATION_THRESHOLD	0x0D010209
#define OID_802_11_RTS_THRESHOLD			0x0D01020A
#define OID_802_11_NUMBER_OF_ANTENNAS		0x0D01020B
#define OID_802_11_RX_ANTENNA_SELECTED		0x0D01020C
#define OID_802_11_TX_ANTENNA_SELECTED		0x0D01020D
#define OID_802_11_SUPPORTED_RATES			0x0D01020E
#define OID_802_11_DESIRED_RATED			0x0D010210
#define OID_802_11_CONFIGURATION			0x0D010211
#define OID_802_11_STATISTICS				0x0D010212
#define OID_802_11_ADD_WEP					0x0D010113
#define OID_802_11_REMOVE_WEP				0x0D010114
#define OID_802_11_DISASSOCIATE				0x0D010115
#define OID_802_11_POWER_MODE				0x0D010216
#define OID_802_11_BSSID_LIST				0x0D010217
#define OID_802_11_BSSID_LIST_SCAN			0x0D01011A
#define OID_802_11_AUTHENTICATION_MODE		0x0D010118
#define OID_802_11_PRIVACY_FILTER			0x0D010119
#define OID_802_11_CHANNEL					0x0D01011B


//OID_802_11_INFRASTRUCTURE_MODE
#define Ndis802_11IBSS						0
#define Ndis802_11Infrastructure			1
#define Ndis802_11AutoUnknown				2

//OID_802_11_AUTHENTICATION_MODE
#define Ndis802_11AuthModeOpen				0
#define Ndis802_11AuthModeShared			1
#define Ndis802_11AuthModeAutoSwitch		2

#define Ndis802_Passive						0
#define Ndis802_Active						1

// 1: normal, 2: scan only
#define Ndis802_Normal						1
#define Ndis802_ScanOnly					2

//country_code information
#define DOMAIN_NUM				7
#define CHANNEL_NUM				14+1

#define CI_FCC					0
#define CI_IC					1
#define	CI_ETSI					2
#define CI_SPAIN				3
#define	CI_FRANCE				4
#define	CI_MMK					5
#define CI_MMK2					6

// Data rate
// Jeffrey01062003
#define DATA_RATE_1MBPS_SIGNAL          0x0A
#define DATA_RATE_2MBPS_SIGNAL          0x14
#define DATA_RATE_5_5MBPS_SIGNAL        0x37
#define DATA_RATE_11MBPS_SIGNAL         0x6E

/* Beacon Transmission Time */
#define BEACON_TRANSMISSION_TIME        0xb8
#define MMI_READ_ADDRESS_1              0x74

typedef struct _AP_INFO_
{
	//UINT8		Time_Stamp[8];
	UINT32		Time_Stamp_L;
	UINT32		Time_Stamp_H;
	UINT16		Beacon_Interval;
	UINT16		Capability_Information;
	UINT8		Channel;
	UINT8		AP_Addr[6];
	UINT8		BSSID[6];
	UINT8		SSID[33];			//{0x07, 'W','L','A','N','_','T','1'}
	UINT8		Support_Rate[9];	//{0x04,0x82,0x84,0x0b,0x16,0x00,0x00,0x00,0x00}
	UINT8		TIM[256];			//see Fig.40 p57, store element_id in TIM[0]
}AP_INFO;

typedef struct _STA_MODULE_
{
	//you can add more items if you needed
	UINT16		MDL_AID;
	UINT8		MDL_Challenge_Text[128];
	//UINT8		MDL_Current_State;
	UINT8		MDL_Current_Action;
	UINT8		MDL_Max_Basic_Data_Rate;		//manage frame
	UINT8		MDL_Max_Data_Rate;				//data frame
	UINT8		MDL_Channel_Inuse;
	UINT8		MDL_Revision;					//AA AB BA
	
	UINT8		*MDL_TX_Buf;
	int			MDL_TX_Len;
	
	int			MDL_Assoc_Complete;
	int			MDL_Auth_Retry_Count;
	int			MDL_Assoc_Retry_Count;
	int			MDL_ReAssoc_Retry_Count;
	int			MDL_Scan_Only;				// 1: normal, 2: scan only
	
	
	int			MDL_Time;
	void		(*MDL_Time_Function)(UINT32*);
	
	int			MDL_AP_Info_Index;			//how many array in use
	int			MDL_AP_Info_Num;			//number of AP after scan
	int			MDL_AP_Select_Type;			//by SSID or Channel
	int			MDL_AP_Inuse_Index;			//now in use index
	AP_INFO		MDL_AP_Info[MAX_AP_NUM];	//collect all AP's informatioin array
	AP_INFO		MDL_AP_Inuse;				//current AP to connect with STA
	AP_INFO		MDL_ADHOC_Mode;				//being adhoc-mode header
	
	//the following data is needed to fill by LMAC
	UINT32		*MDL_pDrvObj;
	UINT8		MDL_Data_Rate;
	UINT8		MDL_STA_MAC[6];
	UINT8		MDL_Support_Rate[9];		//{0x04,0x82,0x84,0x0b,0x16,0x00,0x00,0x00,0x00}
	UINT8		MDL_Channel;				//1~14		0: scan channel
	UINT8		MDL_WEP_Enable;				//0: open	1: WEP
	UINT8		MDL_WEP_Key_Index;			//0~3
	UINT8		MDL_Challenge_Text_Length;	//default 0x80 =  128
	UINT8		MDL_WEP_Key_Length;			//5 or 13
	UINT8		MDL_WEP_Key[4][13];			//WEP key
	UINT8		MDL_SSID[33];				//{0x07, 'W','L','A','N','_','T','1'}
	UINT8		MDL_Retry_Count;
	UINT8		MDL_Preamble;				//0: long		1: short
	UINT8		MDL_Operation_Mode;			//0: adhoc mode,1: infrastructure mode
	UINT8		MDL_Action;					//0: passive	1: active
	UINT8		MDL_Country_Code;			//0~6
	UINT8		MDL_TX_Power;				//(0x00~0x3F), default: 0x2F
	UINT8		MDL_Antenna;				//1:A	2:B		3:D
	/*For ADM8211B Jeffrey01072003*/
	UINT8		MDL_MgnFrameSignal;
	UINT16		MDL_Listen_Interval;
	UINT16		MDL_Beacon_Interval;
	UINT16		MDL_RTS_Thd;
	UINT16		MDL_Frag_Thd;
	
}STA_MDL;
#if 0
//global function
void UM_Init_Module(STA_MDL*);
void UM_MmIndicate(STA_MDL*, int, UINT8*, int);
void UM_Free_Memory(STA_MDL *);
UINT8* UM_3to11(STA_MDL *, UINT8*, int*, UINT8*, int*);
UINT8* UM_11to3(STA_MDL *, UINT8*, int*);
void UM_Clear_SRAM(STA_MDL *);
void UM_Software_WEP(STA_MDL *, UINT8*, int*);

void UM_Query_Information(STA_MDL *, UINT32, UINT8 *, int *);
void UM_Set_Information(STA_MDL *, UINT32, UINT8 *, int *);
#endif
//jeffrey open this debug message 12/18
//#define LM_Print	printk_R1b7d4074	
//#define	_DEBUG_
//#define	_D_OID_
//#define	_ADHOC_
//#define	_SCAN_


#endif	//#ifndef __STA_MODULE_H__

