#define virt_to_le32desc(addr)  cpu_to_le32(virt_to_bus(addr))
#define PKT_BUF_SZ		2500	/* Size of each temporary Rx buffer. */
#define NUM_CHANNELS 14
//#define TX_RING_SIZE	16
#define TX_RING_SIZE	64	
//jeffrey 12.16 for test
#define TX_QUEUE_LEN	10
#define RX_RING_SIZE    64		
#define DESC_RING_WRAP 0x02000000

#define EEPROM_SIZE 	512

#if (LINUX_VERSION_CODE < 0x20100)  ||  ! defined(MODULE)
#define USE_IO_OPS
#endif
#ifndef USE_IO_OPS
#undef inb
#undef inw
#undef inl
#undef outb
#undef outw
#undef outl
#define inb readb
#define inw readw
#define inl readl
#define outb writeb
#define outw writew
#define outl writel
#endif

#ifdef USE_IO_OPS
#define ADM8201_IOTYPE  PCI_USES_MASTER | PCI_USES_IO | PCI_ADDR0
#define ADM8201_SIZE 0x80
#define ADM8201_SIZE1 0x100
#else
#define ADM8201_IOTYPE  PCI_USES_MASTER | PCI_USES_MEM | PCI_ADDR1
#define ADM8201_SIZE   0x400	/* New PCI v2.1 recommends 4K min mem size. */
#define ADM8201_SIZE1	0x400	/* New PCI v2.1 recommends 4K min mem size. */
#endif


/* The bits in the CSR5 status registers, mostly interrupt sources. */
enum status_bits {
    TimerInt = 0x800, TPLnkFail = 0x1000, TPLnkPass = 0x10,
    NormalIntr = 0x10000, AbnormalIntr = 0x8000, PCIBusError = 0x2000,
    RxStopped = 0x100, RxNoBuf = 0x80, RxIntr = 0x40, TxFIFOUnderflow =
	0x20,
    TxLifeTimeOut = 0x08, TxNoBuf = 0x04, TxStopped = 0x02, TxIntr = 0x01,
};

/* The configuration bits in CSR6. */
enum csr6_mode_bits {
    TxOn = 0x2000, RxOn = 0x0002, FullDuplex = 0x0200,
    AcceptBroadcast = 0x0100, AcceptAllMulticast = 0x0080,
    AcceptAllPhys = 0x0040, AcceptRunt = 0x0008,
};

struct adm8201_chip_table {
    char *chip_name;
    int io_size;		/* Unused */
    int valid_intrs;		/* CSR7 interrupt enable settings */
    int flags;
    void (*media_timer) (unsigned long data);
};


/* The Tulip Rx and Tx buffer descriptors. */
struct adm8201_rx_desc {
    s32 status;
    s32 length;
    u32 buffer1, buffer2;
};

struct adm8201_tx_desc {
    s32 status;
    s32 length;
    u32 buffer1, buffer2;	/* We use only buffer 1.  */
};

enum desc_status_bits {
    DescOwned = 0x80000000, RxDescFatalErr = 0x8000, RxWholePkt = 0x0300,
};

struct adm8201_private {
    struct adm8201_rx_desc rx_ring[RX_RING_SIZE];
    struct adm8201_tx_desc tx_ring[TX_RING_SIZE];
    /* The saved addresses of Rx/Tx-in-place packet buffers. */
    struct sk_buff *tx_skbuff[TX_RING_SIZE];
    struct sk_buff *rx_skbuff[RX_RING_SIZE];
    struct net_device *next_module;
    void *priv_addr;		/* Unaligned address of dev->priv for kfree */
    u16 setup_frame[96];	/* Pseudo-Tx frame to init address table. */
    u32 mc_filter[2];		/* Multicast hash filter */
    struct pci_dev *pci_dev;
    int chip_id, revision;
    int flags;
    struct timer_list timer;	/* Media selection timer. */
    unsigned int csr0, csr6;	/* Current CSR0, CSR6 settings. */
    /* Note: cache line pairing and isolation of Rx vs. Tx indicies. */
    unsigned int cur_rx, dirty_rx;	/* Producer/consumer ring indices */
    struct net_device_stats stats;
    unsigned int cur_tx, dirty_tx;
    unsigned int tx_full:1;	/* The Tx queue is full. */
    unsigned int rx_dead:1;	/* We have no Rx buffers. */

    void (*link_change) (struct net_device * dev, int csr5);
    int cur_index;		/* Current media index. */
	int saved_if_port;

/*******************************************************************/
/*			wireless stats				   */
/*******************************************************************/
    struct iw_statistics    wstats;         // wireless stats
    int    beaconcount;			    //should be reset after 2 sec
    int    linkquality;

/*******************************************************************/
/* 			802.11 Header                              */
/*******************************************************************/
    EXTRA_HEADER_BUFFER MSDU[TX_RING_SIZE];	/* This is ADM 8211 MAC HEADER */
    BYTE FramBodayBuffer[134];
    s32 RDES1[RX_RING_SIZE];

/*******************************************************************/
/* Phy info                                                        */
/*******************************************************************/
    BYTE PhyAddr;
    BYTE BasebandType;		// 0:Intersil 1:RFMD 2:Marvel 0xFF: Unknown
    //BYTE TransceiverType;	//Jeffrey01062003

/*******************************************************************/
/* Adapter Info                                                    */
/******************************************************************/
    EEPROM_CONTENT Eeprom;

/*******************************************************************/
/*  Rx Defragment  Parameters                                      */
/*******************************************************************/
    RxDefragment RxDef[3];

/*******************************************************************/
/*  adm8201 UM  Parameters                                         */
/*******************************************************************/
    STA_MDL STA_Module;

    LM_DEVICE_INFO LM_Device;
/****************************************************************/
/*              HOT PLUG                                        */
/****************************************************************/
    int hotplug;
    int mod_count;
/****************************************************************/
/*              Rx	                                        */
/****************************************************************/
    DWORD RxPacketCountPer2S;
};

