#ifndef COMET_H
#define COMET_H

/******************************************************************************/
/* Definitions                                                                */
/******************************************************************************/
/* Receive status */
#define RX_STATUS_ERROR_SUMMARY         BIT_14//BIT_30
#define RX_STATUS_WLAN_SIGNAL_QUALITY   BIT_13
#define RX_STATUS_DESC_ERROR            BIT_12
#define RX_STATUS_FIRST_DESC            BIT_11
#define RX_STATUS_LAST_DESC             BIT_10
#define RX_STATUS_FRAME_RX_DURING_CFP   BIT_9
#define RX_STATUS_PLCP_SFD_ERROR        BIT_8
#define RX_STATUS_PLCP_SIGNAL_ERROR     BIT_7
#define RX_STATUS_PLCP_CRC16_ERROR      BIT_6
#define RX_STATUS_RX_TIMEOUT_ERROR      BIT_5
#define RX_STATUS_CRC32_ERROR           BIT_4
#define RX_STATUS_WEP_ICV_ERROR         BIT_3
//#define RX_STATUS_ALIGNMENT_ERROR       BIT_2
#define RX_STATUS_ADMINISTERED_SDDRESS  BIT_1
#define RX_STATUS_GROUP_ADDRESS         BIT_0
/* Rx Data Rate */
#define RX_STATUS_RX_DATARATE_1M	0
#define RX_STATUS_RX_DATARATE_2M	1
#define RX_STATUS_RX_DATARATE_5_5M	2
#define RX_STATUS_RX_DATARATE_11M	3
#define RX_STATUS_RX_DATARATE_OTHER     15

// Receive descriptor controls RDES1
#define RX_CONTROL_END_OF_RING          BIT_1       	//RxControl Bit1, Bit 25
#define RX_CONTROL_CHAIN_MODE           BIT_0       	//RxControl Bit0, Bit 24

// Transmit status -- TDES0 Status
#define TX_STATUS_ERROR_SUMMARY           BIT_29
#define TX_STATUS_LIFE_TIME_OUT           BIT_28
#define TX_STATUS_RETRY_COUNT_EXPIRED     BIT_27
#define TX_STATUS_UNDERRUN_ERROR          BIT_26
#define TX_STATUS_OVERRUN_ERROR           BIT_25
#define TX_STATUS_SOFB_ERROR              BIT_24



// Transmit control TDES1
#define TX_CONTROL_INTERRUPT_COMPLETE   BIT_7   	// Bit 31
#define TX_CONTROL_LAST_DESC            BIT_6   	// Bit 30
#define TX_CONTROL_FIRST_DESC           BIT_5   	// Bit 29
#define TX_CONTROL_END_OF_RING          BIT_1   	// Bit 25
#define TX_CONTROL_CHAIN_MODE           BIT_0   	// Bit 24
//End010726 for 8201



/******************************************************************************/
/* Configuration registers                                                    */
/******************************************************************************/

/* PCI Vendor and Device ID */
#define CFID_ADM8201	0x82011317
//End010719 for 8201

/*Jeffrey01062003*/
#define REVISION_AB     0x11 //rywu06082002
#define REVISION_AF     0x15
#define REVISION_BA     0x20 //axl11072002 for ADM8211B


//#define SUBCFID_HITACHI 0x01131054 //rywu08282001

#define COMET_PM_CONTROL_STATUS_REG     0xC4        /*Offset in PCI config space */
#define PMCSR_ENABLED_PME_STATUS        BIT_15
#define PMCSR_PME_NOTIFY_OS             BIT_8
#define PMCSR_POWER_STATE_D3            BIT_1_0
#define PMCSR_POWER_STATE_D2            BIT_1
#define PMCSR_POWER_STATE_D1            BIT_0
#define PMCSR_POWER_STATE_D0            BIT_NONE


/* PCI access register */
#define COMET_PCI_ACCESS                0x00

#define PCI_MEMORY_WRITE_INVALIDATE     BIT_24
#define PCI_MEMORY_READ_LINE            BIT_23
#define PCI_MEMORY_READ_MULTIPLE        BIT_21

#define RECEIVE_AUTO_POLLING_DISABLE    0x00
#define RECEIVE_AUTO_POLLING_163us      BIT_17
#define RECEIVE_AUTO_POLLING_655us      BIT_18
#define RECEIVE_AUTO_POLLING_1310us     (BIT_18 | BIT_17)
//End010627 for 8201
#define CACHE_ALIGNMENT_NONE            0x00
#define CACHE_ALIGNMENT_8DW             BIT_14
#define CACHE_ALIGNMENT_16DW            BIT_15
#define CACHE_ALIGNMENT_32DW            (BIT_15 | BIT_14)
#define PCI_BURST_LENGTH_UMLIMITED      0x0000
#define PCI_BURST_LENGTH_1DW            0x0100
#define PCI_BURST_LENGTH_2DW            0x0200
#define PCI_BURST_LENGTH_4DW            0x0400
#define PCI_BURST_LENGTH_8DW            0x0800
#define PCI_BURST_LENGTH_16DW           0x1000
#define PCI_BURST_LENGTH_32DW           0x2000
#define BIG_ENDIAN                      BIT_7
#define DESCRIPTOR_SKIP_LENGTH_1DW      BIT_2
#define DESCRIPTOR_SKIP_LENGTH_2DW      BIT_3
#define DESCRIPTOR_SKIP_LENGTH_4DW      BIT_4
#define DESCRIPTOR_SKIP_LENGTH_8DW      BIT_5
#define DESCRIPTOR_SKIP_LENGTH_16DW     BIT_6
#define TRANSMIT_PRIORITY_HIGH          BIT_1
#define SOFTWARE_RESET                  BIT_0

//Axl010726 for 8201
/* Frame Control register */
#define COMET_FRAME_CONTROL             0x04
#define POWER_MANAGEMENT                BIT_31	//Frame control field bit 12
#define PROTOCOL_VERSION                BIT_30 | BIT_29
#define ORDER_BIT                       BIT_28
#define MAX_POWER_SAVING                BIT_27
//End010726 for 8201

/* Transmit demand */
#define COMET_TRANSMIT_DEMAND           0x08


/* Receive demand */
#define COMET_RECEIVE_DEMAND            0x10


/* Receive descriptor base address */
#define COMET_RX_DESC_BASE_ADDR         0x18


/* Transmit descriptor base address */
//Axl010627 for 8201
#define COMET_TX_DESC_BASE_ADDR_DCF     0x20
#define COMET_TX_DESC_BASE_ADDR_PCF     0x24
//End010627


/* Interrupt status register 1 */
#define COMET_INT_STATUS1               0x28
//Axl010726 for 8201
#define INT_STATUS_STA_INTO_PCF_PERIOD  BIT_31
#define INT_STATUS_BEACON_TRANSMIT_OK   BIT_30
#define INT_STATUS_GPIO_INTERRUPT       BIT_29
#define INT_STATUS_LINK_OFF             BIT_28
#define INT_STATUS_ATIM_TRANSMIT_OK     BIT_27
#define INT_STATUS_TSFT_OUT_OF_RANGE    BIT_26
#define INT_STATUS_TSC_COUNT_TO_ZERO    BIT_25
#define INT_STATUS_LINK_ON              BIT_24
#define INT_STATUS_SIGNAL_QUALITY       BIT_23
//End010726
#define INT_STATUS_NORMAL               BIT_16
#define INT_STATUS_ABNORMAL             BIT_15
#define INT_STATUS_TX_EARLY             BIT_14	//Axl010627 for 8201
#define INT_STATUS_FATAL_BUS_ERROR      BIT_13
#define INT_STATUS_RX_EARLY             BIT_12	//Axl010627 for 8201
#define INT_STATUS_GENERAL_TIME_OUT     BIT_11
#define INT_STATUS_WATCH_DOG_TIME_OUT   BIT_9
#define INT_STATUS_RX_STOPPED           BIT_8
#define INT_STATUS_RX_DESC_UNAVAILABLE  BIT_7
#define INT_STATUS_RX_COMPLETED         BIT_6
#define INT_STATUS_TX_UNDER_FLOW        BIT_5
//Axl010627 for 8201
#define INT_STATUS_TX_RETRY_COUNT       BIT_4
#define INT_STATUS_TX_LIFE_TIMEOUT      BIT_3
//End010627
#define INT_STATUS_TX_DESC_UNAVAILABLE  BIT_2
#define INT_STATUS_TX_STOPPED           BIT_1
#define INT_STATUS_TX_COMPLETED         BIT_0

/* Network access register */
#define COMET_NETWORK_ACCESS            0x30

//Axl010627 for 8201
#define TX_CONDI_AFTER_PKT1_FAIL        BIT_31
#define HOST_FLUSH_PKT1                 BIT_30
#define USE_RETRY_COUNT_FROM_CSR28      BIT_29
#define PCF_SUPPORT                     BIT_28		//Axl010726 for 8201
#define MORE_PCF_DATA                   BIT_27		//Axl010920 for 8201
//End010627
#define TX_STORE_AND_FOWARED            BIT_21
#define CSR6_FP                         BIT_21
#define CSR6_PS                         BIT_18
#define CSR6_HBD                        BIT_19
#define EARLY_TX_THRESHOLD_MASK         (BIT_14 | BIT_15)
#define START_TRANSMIT                  BIT_13
#define FORCE_COLLISION                 BIT_12
#define OPERATING_MODE_LOOP_BACK        BIT_10
#define CSR6_FD                         BIT_9
#define MULTICAST_MODE_SELECT           BIT_7
#define PROMISCUOUS_MODE_SELECT         BIT_6
#define STOP_BACK_OFF_COUNTER           BIT_5
#define ACCEPT_ALL_PACKETS              (BIT_6 | BIT_3)
#define START_RECEIVE                   BIT_1

/* Interrupt mask register 1 */
#define COMET_INT_MASK1                 0x38
//Axl010627 for 8201
#define INT_STA_INTO_PCF_PERIOD         BIT_31
#define INT_STA_RECEIVE_BEACON          BIT_30
#define INT_GPIO                        BIT_29
#define INT_LINK_OFF                    BIT_28	//Axl010629 for 8201
#define INT_ATIM_TRANSMIT_COMPLETE      BIT_27	//Axl010726 for 8201
#define INT_TSFT_OUT_OF_RANGE           BIT_26	//Axl010726 for 8201
#define INT_TSC_COUNT_TO_ZERO           BIT_25	//Axl010920 for 8201
#define INT_LINK_ON                     BIT_24	//Axl010920 for 8201
#define INT_SIGNAL_QUALITY              BIT_23	//Axl010920 for 8201
//End010627
#define INT_NORMAL                      BIT_16
#define INT_ABNORMAL                    BIT_15
#define INT_TX_EARLY                    BIT_14	//Axl010627 for 8201
#define INT_BUS_ERROR                   BIT_13
#define INT_RX_EARLY                    BIT_12	//Axl010627 for 8201
#define INT_GENERAL_TIMER               BIT_11
#define INT_WATCH_DOG_TIMER             BIT_9
#define INT_RX_STOPPED                  BIT_8
#define INT_RX_DESC_UNAVAILABLE         BIT_7
#define INT_RX_COMPLETE                 BIT_6
#define INT_TX_UNDER_FLOW               BIT_5
//Axl010627 for 8201
#define INT_TX_RETRY_COUNT              BIT_4
#define INT_TX_LIFE_TIMEOUT             BIT_3
//End010627
#define INT_TX_DESC_UNAVAILABLE         BIT_2
#define INT_TX_STOPPED                  BIT_1
#define INT_TX_COMPLETE                 BIT_0


/* Serial port register */
#define COMET_SERIAL_PORT               0x48

// TEST Register
#define COMET_TEST0                     0x4c

#define INT_STATUS_BUS_ERROR_MASK       (BIT_31 | BIT_30 | BIT_29)
#define INT_STATUS_TX_STATE_MASK        (BIT_28 | BIT_27 | BIT_26)
#define INT_STATUS_RX_STATE_MASK        (BIT_25 | BIT_24 | BIT_23)
#define DISABLE_BOOTROM                 BIT_19
#define BOOTROM_NOT_DETECTED            BIT_18
#define BOOTROM_SOGNATURE_NOT_MATCHED   BIT_17
#define EEPROM_TYPE			BIT_16
#define EEPROM_RECALL                   BIT_15
#define TEST0_TEST_MODE_FOR_BEACON_GEN  BIT_0

#define RX_STATE_STOPPED                0x0000000
#define RX_STATE_READ_DESC              0x0800000
#define RX_STATE_PRE_FETCH              0x1000000
#define RX_STATE_WAITING                0x1800000
#define RX_STATE_SUSPENDED              0x2000000
#define RX_STATE_WRITE_DESC             0x2800000
#define RX_STATE_FLUSH_FIFO             0x3000000
#define RX_STATE_DRAIN_FIFO             0x3800000

#define TX_STATE_STOPPED                0x00000000
#define TX_STATE_READ_DESC              0x04000000
#define TX_STATE_TRANSMITTING           0x08000000
#define TX_STATE_FILL_FIFO              0x0C000000
#define TX_STATE_RESERVED1              0x10000000
#define TX_STATE_RESERVED2              0x14000000
#define TX_STATE_SUSPENDED              0x18000000
#define TX_STATE_WRITE_DESC             0x1C000000
//Axl010726 for 8201
//End010627


//Axl010726 for 8201
#define COMET_WAKE_UP_CONTROL           0x50
#define Wakeup_CRTC                     BIT_30
#define Wakeup1_Centaur                 BIT_29
#define Wakeup2_Centaur                 BIT_28
#define Wakeup3_Centaur                 BIT_27
#define Wakeup4_Centaur                 BIT_26
#define Wakeup5_Centaur                 BIT_25
#define LINK_OFF_BEACON_LOST_NUMBER     BIT_23 | BIT_22 | BIT_21
#define TSFT_OUT_OF_RANGE_WAKEUP_ENABLE BIT_20
#define TIM_WAKEUP_ENABLE               BIT_19
#define ATIM_WAKEUP_ENABLE              BIT_18
#define KEY_UPDATE_WAKEUP_ENABLE        BIT_17
#define WSCR_WAKE_UP_ENABLE             BIT_10
#define WSCR_MAGIC_ENABLE               BIT_9
#define WSCR_LINK_CHANGE_ENABLE         BIT_8
#define KEY_UPDATE_EVENT   		BIT_6
#define TSFT_OUT_OF_RANGE_EVENT         BIT_5
#define TIM_REVEIVED                    BIT_4
#define ATIM_REVEIVED                   BIT_3
#define WSCR_WAKE_UP_REVEIVED           BIT_2
#define WSCR_MAGIC_REVEIVED             BIT_1
#define WSCR_LINK_CHANGE_REVEIVED       BIT_0
//End010726

#define COMET_WAKE_UP_DATA              0x54

#define COMET_GENERAL_PURPOSE_TIMER     0x58

#define GPIO_CONTROL                    0x5c

//Axl010726 for 8201
#define BBP_CONTROL_PORT                0x60
#define THREE_WRITE_INTRFACE            BIT_31 //INTERSIL needs, RFMD doesn't care
#define RF3000_ADDRESS                  BIT_29 //[30:24]. only RFMD needs
#define NEGATIVE_EDGE_DATA_OUT          BIT_23
#define NEGATIVE_EDGE_DATA_IN           BIT_22
#define CCA_LOW_BUSY 		        BIT_21 //only RFMD needs
#define BBP_TYPE_MASK 		        (BIT_20 | BIT_19 | BIT_18)
#define BBP_WRITE                       BIT_17
#define BBP_READ                        BIT_16
#define BBP_ADDRESS_INDEX      		8	//Shift 8 bit
#define BBP_TYPE_INDEX      		18	//Shift 18 bit
//End010726

//Axl010920 for 8201
#define SYNTHESIZER_CONTROL             0x64
#define SYN_WRITE                       BIT_31
#define SYN_READ                        BIT_30
#define IF_SELECT                       BIT_29
#define RF_SELECT                       BIT_28
#define RF_CAL_CONTROL_SOURCE           BIT_26 //INTERSIL needs after initializing BBP
//for Intersil 3863/3861
#define TYPE_INTERSIL                   0x00
#define TYPE_RFMD                       0x01
#define TYPE_MARVEL                     0x02
#define INTERSIL_IF_OP			0x0035
#define INTERSIL_IF_CA			0x0067
#define INTERSIL_IF_R			0x0160
#define INTERSIL_IF_AB			0x5c66
#define INTERSIL_RF_OP			0x02c0
#define INTERSIL_RF_R			0x0075
#define INTERSIL_RF_AB_CHANNEL_1	0x0fe5e
#define INTERSIL_RF_AB_CHANNEL_2	0x0feae
#define INTERSIL_RF_AB_CHANNEL_3	0x0fefe
#define INTERSIL_RF_AB_CHANNEL_4	0x1004e
#define INTERSIL_RF_AB_CHANNEL_5	0x1009e
#define INTERSIL_RF_AB_CHANNEL_6	0x100ee
#define INTERSIL_RF_AB_CHANNEL_7	0x1023e
#define INTERSIL_RF_AB_CHANNEL_8	0x1028e
#define INTERSIL_RF_AB_CHANNEL_9	0x102de
#define INTERSIL_RF_AB_CHANNEL_10	0x1042e
#define INTERSIL_RF_AB_CHANNEL_11	0x1047e
#define INTERSIL_RF_AB_CHANNEL_12	0x104ce
#define INTERSIL_RF_AB_CHANNEL_13	0x1061e
#define INTERSIL_RF_AB_CHANNEL_14	0x106de
#define RFMD_STEP_1			0x00032
#define RFMD_STEP_2			0x00000
#define RFMD_STEP_3			0x00001
#define RFMD_STEP_4			0x05D85
#define RFMD_STEP_5			0x00588
#define RFMD_STEP_6			0x00587
#define RFMD_CHANNEL_1			0x07F64
#define RFMD_CHANNEL_2			0x07FB4
#define RFMD_CHANNEL_3			0x08004
#define RFMD_CHANNEL_4			0x08054
#define RFMD_CHANNEL_5			0x080A4
#define RFMD_CHANNEL_6			0x080F4
#define RFMD_CHANNEL_7			0x08144
#define RFMD_CHANNEL_8			0x08194
#define RFMD_CHANNEL_9			0x081E4
#define RFMD_CHANNEL_10			0x08234
#define RFMD_CHANNEL_11			0x08284
#define RFMD_CHANNEL_12			0x082D4
#define RFMD_CHANNEL_13			0x08324
#define RFMD_CHANNEL_14			0x083E4
#define RFMD2948			0xA0//Jeffrey01062003 needs to define
#define RFMD2958_RF3000_CONTROL_POWER   0xFE//Jeffrey06232003
#define RFMD2958			0xFF//Jeffrey01062003 needs to define

#define PLCP_HEADER	                0x68
#define SHORT_PREAMBLE      		BIT_15
#define PLCP_SIGNAL_INDEX      		24	//Shift 24 bit
#define PLCP_SERVICE_INDEX      	16	//Shift 16 bit
#define MAX_TX_POWER                    0x2f
#define MIN_TX_POWER                    0x20

#define MMI_WRITE_ADDRESS               0x6C
#define MMI_WRITE_ADDR_FOR_INTERSIL     0x100E0C0A
#define MMI_WRITE_ADDR_FOR_RFMD         0x00009101

#define MMI_READ_ADDRESS_0              0x70
#define MMI_READ_ADDR_1_FOR_INTERSIL    0x00007c7e
#define MMI_READ_ADDR_1_FOR_RFMD        0x00000301

#define MMI_READ_ADDRESS_1              0x74
#define MMI_READ_ADDR_2_FOR_INTERSIL    0x00100000
#define MMI_READ_ADDR_2_FOR_RFMD        0x7e100000
#define RX_PE_COUNT                     0x00100000

#define MMI_SERVICE_INDEX      		8	//Shift 8 bit
#define MMI_LEN_HIGH_INDEX      	16	//Shift 16 bit
#define MMI_LEN_LOW_INDEX      		24	//Shift 24 bit
#define MMI_STATUS_INDEX      		24	//Shift 24 bit

/* Transmit burst count */
#define COMET_TRANSMIT_BURST            0x78

/* Timing Offset Parameter 2*/
#define TIMIMG_OFFSET_PARAMETER_2       0x84

/* Command register */
#define COMET_COMMAND                   0x88

#define D3_SUPPORT                      BIT_31
#define PME_PULSE_SELECT		BIT_27
#define PMES_STICKY			BIT_24
#define CLOCK_RUN_DISABLE               BIT_20
#define POWER_MANAGEMENT_ENABLE         BIT_19
#define WAKE_ON_LAN_ENABLE              BIT_18
#define PME_SHORE_PULSE_         	BIT_8
#define FORCE_PME_EN			BIT_7
#define RESET_WAKEUP_PATTERN_POINTER    BIT_6
#define RECEIVE_THRESHOLD_ENABLE        BIT_4
#define DRAIN_RECEIVE_THRESHOLD_MASK    (BIT_2 | BIT_3)
#define GENERATE_SOFTWARE_INTERRUPT     BIT_1

#define DRAIN_RECEIVE_THRESHOLD_8DW                 0x00
#define DRAIN_RECEIVE_THRESHOLD_16DW                0x04
#define DRAIN_RECEIVE_THRESHOLD_STORE_AND_FORWARD   0x08
//End010920

/* Comet IO registers */
#define COMET_LAN_ADDR1                 0x94	//Axl010627 for 8201 0xa4
#define COMET_LAN_ADDR2                 0x98	//Axl010627 for 8201 0xa8

/* Multicast address */
#define COMET_MULTICAST_ADDR1           0x9c	//Axl010627 for 8201 0xac
#define COMET_MULTICAST_ADDR2           0xa0	//Axl010627 for 8201 0xb0

//Axl010627 for 8201 
/* ATIM frame address */
#define ATIM_FRAME_ADDR1           	0xa4
#define ATIM_FRAME_ADDR2          	0xa8

/* BSSID address */
#define BSSID_FRAME_ADDR2          	0xa8
#define BSSID_FRAME_ADDR1           	0xac

/* WLAN MAX TX MSDU Life time and Short/Long retry limit Control */
#define TX_LIFE_LIMIT_TIME           	0xb0
#define TX_LIFE_TIME_INDEX		16	//shift 16 bits
#define LONG_RETRY_LIMIT           	0x00ff
//End010627

/* MIB counter */
#define MIB_COUNTER            	        0xb4

/* Beacon Transmission Time */
#define BEACON_TRANSMISSION_TIME        0xb8

/* Time Stamp Register High Portion */
#define TIME_STAMP_REG_0                0xbc

/* Synthersizer RF/IF direct control */
#define SYN_RF_IF_DIRECT_CONTROL        0xc4


//Jeffrey01062003
//axl10032002
#define CSR33_IF_SELECT_0            BIT_31
#define CSR33_IF_SELECT_1            (BIT_31 | BIT_28)
#define CSR33_WRITE_SYNDATA_1        (BIT_31 | BIT_26)
#define CSR33_WRITE_SYNDATA_0        BIT_31
#define CSR33_WRITE_CLOCK_1          (BIT_31 | BIT_27)
#define CSR33_WRITE_CLOCK_0          BIT_31
//
////LIC1003 #define BBP_REG                               0x000000FF    //bit[7:0]
#define BBP_VALUE                       0x0000FF00    //bit[15:8]
////axlend


/* Beacon listen and STA listen interval */
#define STA_LISTEN_AND_BEACON_INTERVAL  0xc8
#define DEFAULT_BEACON_INTERVAL         0x64 // 10 beacons/sec
#define DEFAULT_STA_LISTEN_INTERVAL     0x08

/* Capability Information 0 */
#define CAPABILITY_INFORMATION_0        0xcc

/* Capability Information 1 */
#define CAPABILITY_INFORMATION_1        0xd0

/* RX Max Duration */
#define RX_MAX_DURATION                 0xd4
#define BASIS_WAITING_TIME_TO_IDLE      0x00010000  // 1 sec

/* CFP Parameter */
#define CFP_PARAMETER                   0xd8

/* Timing offset parameter 0 */
#define TIMING_OFFSET_PARAMETER_0       0xdc

/* Timing offset parameter 1 */
#define TIMING_OFFSET_PARAMETER_1       0xe0
#define TIME_UNIT                       1024 //1 time unit = 1024 us = 1 ms
#define RX_TSFT_OFFSET                  0x01000000 //Set 1 us, using CSR[31:24]
#define AWAKE_TIME_OFFSET               0x00000002 //Set 2 time units, using CSR[7:0]
#define TIME_1000MS                     0x000f4240

/* IFS Timing Parameter */
#define IFS_TIMING                      0xe4

/* Response Timer */
#define RESPONSE_TIMER                  0xe8

/* Time Stamp Register Low Portion */
#define TIME_STAMP_REG_1                0xec

/* WEP Control */
#define WEP_CONTROL                     0xf0
#define WEP_ENABLE                      BIT_31
#define AUTO_SWITCH_ENABLE              BIT_30
#define WRITE_TABLE                     BIT_28
#define READ_TABLE                      BIT_27
#define RX_WEP_BYPASS                   BIT_25
/* start addresses of SSID and Support Rate in SRAM */
#define SINGLE_TABLE_INDIVIDUAL_KEY_ADDR 0x0000
#define SINGLE_TABLE_SHARE_KEY_ADDR      0x0160
#define SSID_ADDRESS_IN_SRAM             0x0180
#define SUPPORT_RATE_ADDRESS_IN_SRAM     0x0191
#define SRAM_SIZE                        0x0200


/* Write entry for share/individual key */
#define SRAM_DATA_ENTRY                 0xf4

/* MAC Test Register */
#define MAC_TEST_REG                    0xfc
#define TX_MMI_DATA_BY_TXCLK            BIT_11
#define FORCE_KEY_ID                    BIT_22
#define FORCE_IV                        BIT_23
#define KEY_ID_0                        0x00000000
#define KEY_ID_1                        0x00100000
#define KEY_ID_2                        0x00200000
#define KEY_ID_3                        0x00300000

/* Frequency */
#define CHANNEL_ID_1                    2412
#define CHANNEL_ID_2                    2417
#define CHANNEL_ID_3                    2422
#define CHANNEL_ID_4                    2427
#define CHANNEL_ID_5                    2432
#define CHANNEL_ID_6                    2437
#define CHANNEL_ID_7                    2442
#define CHANNEL_ID_8                    2447
#define CHANNEL_ID_9                    2452
#define CHANNEL_ID_10                   2457
#define CHANNEL_ID_11                   2462
#define CHANNEL_ID_12                   2467
#define CHANNEL_ID_13                   2472
#define CHANNEL_ID_14                   2484

// Data rate
#define DATA_RATE_1MBPS_SIGNAL	        0x0A
#define DATA_RATE_2MBPS_SIGNAL	        0x14
#define DATA_RATE_5_5MBPS_SIGNAL        0x37
#define DATA_RATE_11MBPS_SIGNAL	        0x6E
#define SUPPORT_RATE_1MBPS      	0x02
#define SUPPORT_RATE_2MBPS              0x04
#define SUPPORT_RATE_5_5MBPS            0x0b
#define SUPPORT_RATE_11MBPS	       	0x16
#define SUPPORT_RATE_1MBPS_BASIC        0x82
#define SUPPORT_RATE_2MBPS_BASIC        0x84
#define SUPPORT_RATE_5_5MBPS_BASIC	0x8b
#define SUPPORT_RATE_11MBPS_BASIC       0x96

#define CSR_TEST1			0x44
/******************************************************************************/
/* Bit Mask definitions                                                       */
/******************************************************************************/
#if 0 
#define BIT_NONE                    0x00
#define BIT_0                       0x01
#define BIT_1                       0x02
#define BIT_2                       0x04
#define BIT_3                       0x08
#define BIT_4                       0x10
#define BIT_5                       0x20
#define BIT_6                       0x40
#define BIT_7                       0x80
#define BIT_8                       0x0100
#define BIT_9                       0x0200
#define BIT_10                      0x0400
#define BIT_11                      0x0800
#define BIT_12                      0x1000
#define BIT_13                      0x2000
#define BIT_14                      0x4000
#define BIT_15                      0x8000
#define BIT_16                      0x010000
#define BIT_17                      0x020000
#define BIT_18                      0x040000
#define BIT_19                      0x080000
#define BIT_20                      0x100000
#define BIT_21                      0x200000
#define BIT_22                      0x400000
#define BIT_23                      0x800000
#define BIT_24                      0x01000000
#define BIT_25                      0x02000000
#define BIT_26                      0x04000000
#define BIT_27                      0x08000000
#define BIT_28                      0x10000000
#define BIT_29                      0x20000000
#define BIT_30                      0x40000000
#define BIT_31                      0x80000000
#define BIT_1_0                     0x03
#endif

#endif /* COMET_H */

