/* Basic type definitions */
typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;
//typedef u64 ULONGLONG;


//#define LM_Print	printk_R1b7d4074	
//#define ioctl_debug 		1
//#define packet_debug		1
//#define defragment_debug	1
//#define lm_debug
//adm8201_debug must reserve
#define adm8201_debug 1


/******************************************************************************/
/* 		RF 				                              */
/******************************************************************************/

/* Antenna definition */
#if 0
#define ANTENNA_A       0x00
#define ANTENNA_B       0x40
#define DIVERSITY       0x80
#endif
/******************************************************************************/
/* Constants                                                                  */
/******************************************************************************/

#define CRC_SIZE                            4

#define ADM8201_MSDU_HEADER_SIZE            56 // Length of 8201 packet header.
#define EXTRA_HEADER_BUFFER_SIZE            64 //ADM8201_MSDU_HEADER_SIZE + TRANSLATE_HEADER_SIZE + EXTRA_LENGTH_2_BYTES
#define MSDU_HEADER_SIZE	 	    62 //  62 << 11bits = 0x00031000  (buffer1 length = 11 bits)

#define UNDETERMINED_IBSS_BEACON_SIZE       55 //802.11 header(24),TimeStamp(8),
					       //BeaconInterval(2),CapInfo(2),
					       //SSID(2+SSID_LENGTH),
					       //SupportRate(6),DSset(3),
					       //IBSSset(4),CRC(4)
#define CHALLENAGE_TEXT_SIZE                0x80
#define IV_LENGTH                           0x4 //rywu04102002
#define MAX_EEPROM_SIZE                     0x200 //rywu05312002

#define WIRELESS_DATA_HEADER_SIZE           30 // Real wireless data header size
#define WIRELESS_MANAGEMENT_HEADER_SIZE     24 // Real wireless management header size

#define MANAGMENT_FRAME			    0x00
#define CONTROL_FRAME			    0x04
#define DATA_FRAME			    0x08



#define MAX_LOST_BEACON                     7

#define SHARED_KEY_40_BIT                   1
#define SHARED_KEY_104_BIT                  2

#define LONG_PREAMBLE_MODE                  0x00
#define SHORT_PREAMBLE_MODE                 0x01

//******* for iwconfig tools *****************
#define AUTH_OPEN			    0x00	//disable
#define AUTH_ENCRYPT			    0x01	//only wep
#define AUTH_SHAREDKEY			    0x02	// wep and sharekey

#define Enable								0x00
#define Disable								0x01



/**************************************************/
/* ADM8201 data structure for various frame type  */
/**************************************************/
//
// ADM8201 Specific Data Header
//
typedef struct {
	union {
		BYTE Headers[EXTRA_HEADER_BUFFER_SIZE];
		struct {
			BYTE  DA[6];
			BYTE  Signal;
			BYTE  Service;
			WORD  FrameBodySize;
			WORD  FrameControl;
			WORD  PLCPFragTailLen;
			WORD  PLCPFragHeadLen;
			WORD  DurFragTail;
			WORD  DurFragHead;
			BYTE  Address4[6];
			WORD  HeaderControl;
			DWORD FragThreshold:12;
			DWORD Reserved_0:8;
			DWORD FragNumber:4;
			DWORD RetryLimit:8;

			//rywu04262002
			DWORD Wep2Key0;
			DWORD Wep2Key1;
			DWORD Wep2Key2;
			DWORD Wep2Key3;
			DWORD KeyID:8;
			DWORD Reserved_1:24;
			DWORD Reserved_2;

			BYTE  TransHeader[6];
			BYTE  Reserved_3[2];
		};
	}Content; // union
} EXTRA_HEADER_BUFFER, *PEXTRA_HEADER_BUFFER;



//
// EEPROM content. rywu05312002
//
typedef struct  // EEPROM_FROMAT
{
			WORD Signature;           //00h ~ 01h
        		BYTE Majorversion;        //02h
        		BYTE MinorVersion;        //03h
        		BYTE Reserved01[4];       //04h ~ 07h
        		BYTE EthernetAddress[6];  //08h ~ 1Dh
        		BYTE Reserved02[8];       //1Eh ~ 15h
        		WORD CR49_Value;          //16h ~ 17h
        		//BYTE Reserved03[8];       //18h ~ 1Fh
			//Jeffrey01062003
			BYTE CR03;		  //18h
			BYTE CR28;		  //19h
			BYTE CR29;		  //1ah
			BYTE CountryCode;	  //1bh
			BYTE SpecificBBPType;	  //1ch
			BYTE SpecificRFType;	  //1dh
			BYTE Reserved03[2];	  //1eh ~ 1fh	
        		WORD DeviceID;            //20h ~ 21h
        		WORD VendorID;            //22h ~ 23h
        		WORD SubsystemID;         //24h ~ 25h
        		WORD SubsystemVendorID;   //26h ~ 27h
		        BYTE MaxLat;              //28h
		        BYTE MinGnt;              //29h
		        WORD CISPointerLow;       //2Ah ~ 2Bh
		        WORD CISPointerHigh;      //2Ch ~ 2Dh
		        WORD CSR18Recall;         //2Eh ~ 2Fh
		        BYTE Reserved04[16];      //30h ~ 3Fh
		        BYTE D1PwrDara;           //40h
		        BYTE D0PwrDara;           //41h
		        BYTE D3PwrDara;           //42h
		        BYTE D2PwrDara;           //43h
		     //   BYTE Reserved05[14];      //44h ~ 51h
			WORD AntennaPower[7];   
		        WORD CISWordCount;        //52h ~ 53h
		        WORD TxPwr[7];            //54h ~ 61h
		        WORD LPFCutoff[7];        //62h ~ 6Fh
		        WORD LNAGSThreshold[7];   //70h ~ 7Dh
		        WORD Checksum;            //7Eh ~ 7Fh
		        WORD CISData[192];        //80h ~ 200h
} EEPROM_CONTENT, *PEEPROM_CONTENT;


enum adm8201_offsets {
    CSR0   = 0x00, CSR0A = 0x04, CSR1   = 0x08, CSR1A = 0x0c,  CSR2  = 0x10,
	CSR2A  = 0x14, CSR3  = 0x18, CSR4   = 0x20, CSR4A = 0x24,  CSR5  = 0x28,
	CSR6   = 0x30, CSR7  = 0x38, CSR8   = 0x40, CSR8A = 0x44,  CSR9  = 0x48,
	CSR9A  = 0x4c, CSR10 = 0x50, CSR10A = 0x54, CSR11 = 0x58,  CSR12 = 0x60,
	CSR12A = 0x64, CSR13 = 0x68, CSR14  = 0x70, CSR15 = 0x78,  CSR17 = 0x84,
	CSR18  = 0x88, CSR19 = 0x8c, CSR20  = 0x90, CSR21 =	0x94,  CSR22 = 0x98,
    CSR23  = 0x9C, CSR24 = 0xA0, CSR25  = 0xA4, CSR26 = 0xA8,  CSR27 = 0xAC,
	CSR28  = 0xB0, CSR29 = 0xB4, CSR30  = 0xB8, CSR31 = 0xBC,  CSR32 = 0xC0,
	CSR33  = 0xC4, CSR34 = 0xC8, CSR35  = 0xCC, CSR36 = 0xD0,  CSR37 = 0xD4,
	CSR38  = 0xD8, CSR39 = 0xDC, CSR40  = 0xE0, CSR41 = 0xE4,  CSR42 = 0xE8,
	CSR43 = 0xEC,  CSR44 = 0xF0, CSR45  = 0xF4, CSR46 = 0xF8,
    CSR47 = 0xFC
};

typedef struct {
	BYTE data[2000];
	WORD data_len;
    WORD fra_SeqNum;
    BYTE fra_FraNum;
    BYTE MAC[6];
    BYTE Inside;
    BYTE TimeStatus;
}RxDefragment;

typedef struct {
	unsigned long		*MDL_pDrvObj;
	unsigned long		*DEVICE_pDrvobj;
	BYTE			BasebandType;
	BYTE 			TransceiverType;       //Jeffrey01062003
	BYTE			AntennaSelection;
	WORD			TxPwr[7];
	DWORD   		CSR0_Values;
	DWORD   		CSR7_Values;
	BYTE			MAC_addr[6];

/*******************************************************************/
/* Adapter Info                                                    */
/******************************************************************/

    DWORD WakeupFrame;
    DWORD MagicPacket;
    DWORD NetworkAccess;
    DWORD ATIMWindow;

/*******************************************************************/
/* Configurable parameters                                         */
/*******************************************************************/
    DWORD 			DataSignal;
    WORD  			SsidLength;
    WORD 			SoftwareWep;
    DWORD 			BeaconInterval;
    DWORD 			LostBeaconCount;

/*******************************************************************/
/* 			WEP info                                   */
/*******************************************************************/
    DWORD 			WepIV;

    WORD 			IBSS_Beacon_size;
    WORD 			AID;
    WORD 			STAListenInterval;
    BYTE 			HighBasicRate;
    BYTE 			ProbeReqTargetAddress[6];
    BYTE 			AuthTargetAddress[6];

    // For supported Rates
    BYTE 			DataRateSet[8];

    // For frequency hopping
    BYTE 			HopPattern;
    BYTE 			HopSet;
    WORD 			DwellTime;

    WORD 			RSSI;
    WORD 			MgnFrameSignal;

/*******************************************************************/
/* Interrupt masks                                                 */
/*******************************************************************/
    DWORD 			IntMask2;		/* COMET_INT_MASK2 */
    DWORD 			IntMaskBackUp;	//fortest39
    DWORD 			InterruptStatus;

/*******************************************************************/
/*  adm8201 for iwconfig Parameters                                */
/*******************************************************************/
	DWORD			iw_mode;
	BYTE			NicName[50];
	WORD			authType;
	BYTE			freq_channel; //  0: channel 1:frequecny
	BYTE    		TxPowerFlag; //  0: Enable  1:Disable

	BYTE			Start_ADM8211;
	BYTE			Start_Tx;
	BYTE			UmInitModule_Flag;

	WORD			BeaconCount;
	BYTE			LostBeaconFlag;

/*******************************************************************/
/*  Rx Defragment  Parameters                                      */
/*******************************************************************/
	RxDefragment	 	RxDef[3];
	BYTE 			CompleteQueueNum;
	BYTE    		NumofQueue;


	/*EEPROM information*/
	EEPROM_CONTENT Eeprom;
	BYTE		CR28;
	BYTE		RevisionStep;

}LM_DEVICE_INFO;

