/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.PrintWriter;
import org.apache.catalina.Cluster;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.catalina.storeconfig.StoreFactoryBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StandardHostSF
extends StoreFactoryBase {
    private static Log log = LogFactory.getLog((Class)StandardHostSF.class);

    public void storeChilds(PrintWriter aWriter, int indent, Object aHost, StoreDescription parentDesc) throws Exception {
        if (aHost instanceof StandardHost) {
            Cluster cluster;
            StandardHost host = (StandardHost)aHost;
            if (host instanceof Lifecycle) {
                Object[] listeners = host.findLifecycleListeners();
                this.storeElementArray(aWriter, indent, listeners);
            }
            String[] aliases = host.findAliases();
            this.getStoreAppender().printTagArray(aWriter, "Alias", indent + 2, aliases);
            Realm realm = host.getRealm();
            if (realm != null) {
                Realm parentRealm = null;
                if (host.getParent() != null) {
                    parentRealm = host.getParent().getRealm();
                }
                if (realm != parentRealm) {
                    this.storeElement(aWriter, indent, realm);
                }
            }
            if (host instanceof Pipeline) {
                Object[] valves = host.getValves();
                this.storeElementArray(aWriter, indent, valves);
            }
            if ((cluster = host.getCluster()) != null) {
                this.storeElement(aWriter, indent, cluster);
            }
            Object[] children = host.findChildren();
            this.storeElementArray(aWriter, indent, children);
        }
    }
}

