/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHostValve;
import org.apache.catalina.core.StandardPipeline;
import org.apache.catalina.startup.HostConfig;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.Registry;

public class StandardHost
extends ContainerBase
implements Host {
    private static Log log = LogFactory.getLog((Class)StandardHost.class);
    private String[] aliases = new String[0];
    private String appBase = ".";
    private boolean autoDeploy = true;
    private String configClass = "org.apache.catalina.startup.ContextConfig";
    private String contextClass = "org.apache.catalina.core.StandardContext";
    private boolean deployOnStartup = true;
    private boolean deployXML = true;
    private String errorReportValveClass = "org.apache.catalina.valves.ErrorReportValve";
    private ObjectName errorReportValveObjectName = null;
    private static final String info = "org.apache.catalina.core.StandardHost/1.0";
    private boolean liveDeploy = true;
    private boolean unpackWARs = true;
    private String workDir = null;
    private boolean xmlValidation = false;
    private boolean xmlNamespaceAware = false;
    private boolean initialized = false;

    public StandardHost() {
        this.pipeline.setBasic(new StandardHostValve());
    }

    public String getAppBase() {
        return this.appBase;
    }

    public void setAppBase(String appBase) {
        String oldAppBase = this.appBase;
        this.appBase = appBase;
        this.support.firePropertyChange("appBase", oldAppBase, this.appBase);
    }

    public boolean getAutoDeploy() {
        return this.autoDeploy;
    }

    public void setAutoDeploy(boolean autoDeploy) {
        boolean oldAutoDeploy = this.autoDeploy;
        this.autoDeploy = autoDeploy;
        this.support.firePropertyChange("autoDeploy", oldAutoDeploy, this.autoDeploy);
    }

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String configClass) {
        String oldConfigClass = this.configClass;
        this.configClass = configClass;
        this.support.firePropertyChange("configClass", oldConfigClass, this.configClass);
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        String oldContextClass = this.contextClass;
        this.contextClass = contextClass;
        this.support.firePropertyChange("contextClass", oldContextClass, this.contextClass);
    }

    public boolean getDeployOnStartup() {
        return this.deployOnStartup;
    }

    public void setDeployOnStartup(boolean deployOnStartup) {
        boolean oldDeployOnStartup = this.deployOnStartup;
        this.deployOnStartup = deployOnStartup;
        this.support.firePropertyChange("deployOnStartup", oldDeployOnStartup, this.deployOnStartup);
    }

    public boolean isDeployXML() {
        return this.deployXML;
    }

    public void setDeployXML(boolean deployXML) {
        this.deployXML = deployXML;
    }

    public boolean getLiveDeploy() {
        return this.autoDeploy;
    }

    public void setLiveDeploy(boolean liveDeploy) {
        this.setAutoDeploy(liveDeploy);
    }

    public String getErrorReportValveClass() {
        return this.errorReportValveClass;
    }

    public void setErrorReportValveClass(String errorReportValveClass) {
        String oldErrorReportValveClassClass = this.errorReportValveClass;
        this.errorReportValveClass = errorReportValveClass;
        this.support.firePropertyChange("errorReportValveClass", oldErrorReportValveClassClass, this.errorReportValveClass);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.nullName"));
        }
        name = name.toLowerCase();
        String oldName = this.name;
        this.name = name;
        this.support.firePropertyChange("name", oldName, this.name);
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(boolean unpackWARs) {
        this.unpackWARs = unpackWARs;
    }

    public void setXmlValidation(boolean xmlValidation) {
        this.xmlValidation = xmlValidation;
    }

    public boolean getXmlValidation() {
        return this.xmlValidation;
    }

    public boolean getXmlNamespaceAware() {
        return this.xmlNamespaceAware;
    }

    public void setXmlNamespaceAware(boolean xmlNamespaceAware) {
        this.xmlNamespaceAware = xmlNamespaceAware;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public void addAlias(String alias) {
        alias = alias.toLowerCase();
        for (int i = 0; i < this.aliases.length; ++i) {
            if (!this.aliases[i].equals(alias)) continue;
            return;
        }
        String[] newAliases = new String[this.aliases.length + 1];
        for (int i = 0; i < this.aliases.length; ++i) {
            newAliases[i] = this.aliases[i];
        }
        newAliases[this.aliases.length] = alias;
        this.aliases = newAliases;
        this.fireContainerEvent("addAlias", alias);
    }

    public void addChild(Container child) {
        if (!(child instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("standardHost.notContext"));
        }
        super.addChild(child);
    }

    public String[] findAliases() {
        return this.aliases;
    }

    public String getInfo() {
        return info;
    }

    public Context map(String uri) {
        int slash;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapping request URI '" + uri + "'"));
        }
        if (uri == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"  Trying the longest context path prefix");
        }
        Context context = null;
        String mapuri = uri;
        while ((context = (Context)this.findChild(mapuri)) == null && (slash = mapuri.lastIndexOf(47)) >= 0) {
            mapuri = mapuri.substring(0, slash);
        }
        if (context == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"  Trying the default context");
            }
            context = (Context)this.findChild("");
        }
        if (context == null) {
            log.error((Object)sm.getString("standardHost.mappingError", uri));
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Mapped to context '" + context.getPath() + "'"));
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlias(String alias) {
        alias = alias.toLowerCase();
        String[] stringArray = this.aliases;
        synchronized (this.aliases) {
            int n = -1;
            for (int i = 0; i < this.aliases.length; ++i) {
                if (!this.aliases[i].equals(alias)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.aliases.length - 1];
            for (int i = 0; i < this.aliases.length; ++i) {
                if (i == n) continue;
                results[j++] = this.aliases[i];
            }
            this.aliases = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeAlias", alias);
            return;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardHost[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    public synchronized void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.realm == null) {
            ObjectName realmName = null;
            try {
                realmName = new ObjectName(this.domain + ":type=Realm,host=" + this.getName());
                if (this.mserver.isRegistered(realmName)) {
                    this.mserver.invoke(realmName, "init", new Object[0], new String[0]);
                }
            }
            catch (Throwable t) {
                log.debug((Object)("No realm for this host " + realmName));
            }
        }
        if (this.errorReportValveClass != null && !this.errorReportValveClass.equals("")) {
            try {
                boolean found = false;
                if (this.errorReportValveObjectName != null) {
                    ObjectName[] names = ((StandardPipeline)this.pipeline).getValveObjectNames();
                    for (int i = 0; !found && i < names.length; ++i) {
                        if (!this.errorReportValveObjectName.equals(names[i])) continue;
                        found = true;
                    }
                }
                if (!found) {
                    Valve valve = (Valve)Class.forName(this.errorReportValveClass).newInstance();
                    this.addValve(valve);
                    this.errorReportValveObjectName = ((ValveBase)valve).getObjectName();
                }
            }
            catch (Throwable t) {
                log.error((Object)sm.getString("standardHost.invalidErrorReportValveClass", this.errorReportValveClass));
            }
        }
        if (log.isInfoEnabled()) {
            if (this.xmlValidation) {
                log.info((Object)sm.getString("standardHost.validationEnabled"));
            } else {
                log.info((Object)sm.getString("standardHost.validationDisabled"));
            }
        }
        super.start();
    }

    public String[] getValveNames() throws Exception {
        Valve[] valves = this.getValves();
        String[] mbeanNames = new String[valves.length];
        for (int i = 0; i < valves.length; ++i) {
            if (valves[i] == null || ((ValveBase)valves[i]).getObjectName() == null) continue;
            mbeanNames[i] = ((ValveBase)valves[i]).getObjectName().toString();
        }
        return mbeanNames;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.getParent() == null) {
            try {
                ObjectName serviceName = new ObjectName(this.domain + ":type=Engine");
                HostConfig deployer = new HostConfig();
                this.addLifecycleListener(deployer);
                if (this.mserver.isRegistered(serviceName)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Registering " + serviceName + " with the Engine"));
                    }
                    this.mserver.invoke(serviceName, "addChild", new Object[]{this}, new String[]{"org.apache.catalina.Container"});
                }
            }
            catch (Exception ex) {
                log.error((Object)"Host registering failed!", (Throwable)ex);
            }
        }
        if (this.oname == null) {
            try {
                StandardEngine engine = (StandardEngine)this.parent;
                this.domain = engine.getName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Register host " + this.getName() + " with domain " + this.domain));
                }
                this.oname = new ObjectName(this.domain + ":type=Host,host=" + this.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
            catch (Throwable t) {
                log.error((Object)"Host registering failed!", t);
            }
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName oname) throws Exception {
        ObjectName res = super.preRegister(server, oname);
        String name = oname.getKeyProperty("host");
        if (name != null) {
            this.setName(name);
        }
        return res;
    }

    public ObjectName createObjectName(String domain, ObjectName parent) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create ObjectName " + domain + " " + parent));
        }
        return new ObjectName(domain + ":type=Host,host=" + this.getName());
    }
}

