/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import java.io.CharConversionException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.coyote.Request;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.jk.common.HandlerDispatch;
import org.apache.jk.common.JkInputStream;
import org.apache.jk.core.JkChannel;
import org.apache.jk.core.JkHandler;
import org.apache.jk.core.Msg;
import org.apache.jk.core.MsgContext;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.threads.ThreadWithAttributes;

public class HandlerRequest
extends JkHandler {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$jk$common$HandlerRequest == null ? (class$org$apache$jk$common$HandlerRequest = HandlerRequest.class$("org.apache.jk.common.HandlerRequest")) : class$org$apache$jk$common$HandlerRequest));
    public static final byte JK_AJP13_FORWARD_REQUEST = 2;
    public static final byte JK_AJP13_SHUTDOWN = 7;
    public static final byte JK_AJP13_PING_REQUEST = 8;
    public static final byte JK_AJP13_CPING_REQUEST = 10;
    public static final byte JK_AJP13_SEND_BODY_CHUNK = 3;
    public static final byte JK_AJP13_SEND_HEADERS = 4;
    public static final byte JK_AJP13_END_RESPONSE = 5;
    public static final byte JK_AJP13_GET_BODY_CHUNK = 6;
    public static final byte JK_AJP13_CPONG_REPLY = 9;
    public static final int SC_RESP_CONTENT_TYPE = 40961;
    public static final int SC_RESP_CONTENT_LANGUAGE = 40962;
    public static final int SC_RESP_CONTENT_LENGTH = 40963;
    public static final int SC_RESP_DATE = 40964;
    public static final int SC_RESP_LAST_MODIFIED = 40965;
    public static final int SC_RESP_LOCATION = 40966;
    public static final int SC_RESP_SET_COOKIE = 40967;
    public static final int SC_RESP_SET_COOKIE2 = 40968;
    public static final int SC_RESP_SERVLET_ENGINE = 40969;
    public static final int SC_RESP_STATUS = 40970;
    public static final int SC_RESP_WWW_AUTHENTICATE = 40971;
    public static final byte SC_A_CONTEXT = 1;
    public static final byte SC_A_SERVLET_PATH = 2;
    public static final byte SC_A_REMOTE_USER = 3;
    public static final byte SC_A_AUTH_TYPE = 4;
    public static final byte SC_A_QUERY_STRING = 5;
    public static final byte SC_A_JVM_ROUTE = 6;
    public static final byte SC_A_SSL_CERT = 7;
    public static final byte SC_A_SSL_CIPHER = 8;
    public static final byte SC_A_SSL_SESSION = 9;
    public static final byte SC_A_SSL_KEYSIZE = 11;
    public static final byte SC_A_SECRET = 12;
    public static final byte SC_A_STORED_METHOD = 13;
    public static final byte SC_A_REQ_ATTRIBUTE = 10;
    public static final byte SC_A_ARE_DONE = -1;
    public static final String[] methodTransArray = new String[]{"OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "PROPFIND", "PROPPATCH", "MKCOL", "COPY", "MOVE", "LOCK", "UNLOCK", "ACL", "REPORT", "VERSION-CONTROL", "CHECKIN", "CHECKOUT", "UNCHECKOUT", "SEARCH", "MKWORKSPACE", "UPDATE", "LABEL", "MERGE", "BASELINE-CONTROL", "MKACTIVITY"};
    public static final int SC_M_JK_STORED = -1;
    public static final int SC_REQ_ACCEPT = 1;
    public static final int SC_REQ_ACCEPT_CHARSET = 2;
    public static final int SC_REQ_ACCEPT_ENCODING = 3;
    public static final int SC_REQ_ACCEPT_LANGUAGE = 4;
    public static final int SC_REQ_AUTHORIZATION = 5;
    public static final int SC_REQ_CONNECTION = 6;
    public static final int SC_REQ_CONTENT_TYPE = 7;
    public static final int SC_REQ_CONTENT_LENGTH = 8;
    public static final int SC_REQ_COOKIE = 9;
    public static final int SC_REQ_COOKIE2 = 10;
    public static final int SC_REQ_HOST = 11;
    public static final int SC_REQ_PRAGMA = 12;
    public static final int SC_REQ_REFERER = 13;
    public static final int SC_REQ_USER_AGENT = 14;
    public static final byte SC_A_SSL_KEY_SIZE = 11;
    public static final String[] headerTransArray = new String[]{"accept", "accept-charset", "accept-encoding", "accept-language", "authorization", "connection", "content-type", "content-length", "cookie", "cookie2", "host", "pragma", "referer", "user-agent"};
    public static final int HOSTBUFFER = 10;
    private static Object lock = new Object();
    HandlerDispatch dispatch;
    String ajpidDir = "conf";
    String requiredSecret = null;
    int bodyNote;
    int tmpBufNote;
    int secretNote;
    boolean decoded = true;
    boolean tomcatAuthentication = true;
    boolean registerRequests = true;
    boolean shutdownEnabled = false;
    static int count = 0;
    static /* synthetic */ Class class$org$apache$jk$common$HandlerRequest;

    public void init() {
        this.dispatch = (HandlerDispatch)this.wEnv.getHandler("dispatch");
        if (this.dispatch != null) {
            this.dispatch.registerMessageType(2, "JK_AJP13_FORWARD_REQUEST", this, null);
            this.dispatch.registerMessageType(7, "JK_AJP13_SHUTDOWN", this, null);
            this.dispatch.registerMessageType(10, "JK_AJP13_CPING_REQUEST", this, null);
            this.dispatch.registerMessageType(13, "HANDLE_THREAD_END", this, null);
            this.dispatch.registerMessageType(3, "JK_AJP13_SEND_BODY_CHUNK", this, null);
        }
        this.bodyNote = this.wEnv.getNoteId(0, "jkInputStream");
        this.tmpBufNote = this.wEnv.getNoteId(0, "tmpBuf");
        this.secretNote = this.wEnv.getNoteId(0, "secret");
        if (this.next == null) {
            this.next = this.wEnv.getHandler("container");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Container handler " + this.next + " " + this.next.getName() + " " + this.next.getClass().getName()));
        }
        this.generateAjp13Id();
    }

    public void setSecret(String s) {
        this.requiredSecret = s;
    }

    public void setUseSecret(boolean b) {
        this.requiredSecret = Double.toString(Math.random());
    }

    public void setDecodedUri(boolean b) {
        this.decoded = b;
    }

    public boolean isTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setShutdownEnabled(boolean se) {
        this.shutdownEnabled = se;
    }

    public boolean getShutdownEnabled() {
        return this.shutdownEnabled;
    }

    public void setTomcatAuthentication(boolean newTomcatAuthentication) {
        this.tomcatAuthentication = newTomcatAuthentication;
    }

    public void setAjpidDir(String path) {
        if ("".equals(path)) {
            path = null;
        }
        this.ajpidDir = path;
    }

    public void setRegisterRequests(boolean srr) {
        this.registerRequests = srr;
    }

    public boolean getRegisterRequests() {
        return this.registerRequests;
    }

    private void generateAjp13Id() {
        int portInt = 8009;
        InetAddress address = null;
        if (this.requiredSecret == null) {
            return;
        }
        File f1 = new File(this.wEnv.getJkHome());
        File f2 = new File(f1, "conf");
        if (!f2.exists()) {
            log.error((Object)("No conf dir for ajp13.id " + f2));
            return;
        }
        File sf = new File(f2, "ajp13.id");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using stop file: " + sf));
        }
        try {
            Properties props = new Properties();
            props.put("port", Integer.toString(portInt));
            if (address != null) {
                props.put("address", address.getHostAddress());
            }
            if (this.requiredSecret != null) {
                props.put("secret", this.requiredSecret);
            }
            FileOutputStream stopF = new FileOutputStream(sf);
            props.store(stopF, "Automatically generated, don't edit");
        }
        catch (IOException ex) {
            log.debug((Object)("Can't create stop file: " + sf));
            ex.printStackTrace();
        }
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        byte type = msg.getByte();
        ThreadWithAttributes twa = null;
        if (Thread.currentThread() instanceof ThreadWithAttributes) {
            twa = (ThreadWithAttributes)Thread.currentThread();
        }
        Object control = ep.getControl();
        MessageBytes tmpMB = (MessageBytes)ep.getNote(this.tmpBufNote);
        if (tmpMB == null) {
            tmpMB = MessageBytes.newInstance();
            ep.setNote(this.tmpBufNote, tmpMB);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handling " + type));
        }
        switch (type) {
            case 2: {
                String epSecret;
                try {
                    if (twa != null) {
                        twa.setCurrentStage(control, "JkDecode");
                    }
                    this.decodeRequest(msg, ep, tmpMB);
                    if (twa != null) {
                        twa.setCurrentStage(control, "JkService");
                        twa.setParam(control, (Object)((Request)ep.getRequest()).unparsedURI());
                    }
                }
                catch (Exception ex) {
                    log.error((Object)"Error decoding request ", (Throwable)ex);
                    msg.dump("Incomming message");
                    return 2;
                }
                if (!(this.requiredSecret == null || (epSecret = (String)ep.getNote(this.secretNote)) != null && this.requiredSecret.equals(epSecret))) {
                    return 2;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Calling next " + this.next.getName() + " " + this.next.getClass().getName()));
                }
                int err = this.next.invoke(msg, ep);
                if (twa != null) {
                    twa.setCurrentStage(control, "JkDone");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoke returned " + err));
                }
                return err;
            }
            case 7: {
                String epSecret = null;
                if (msg.getLen() > 3) {
                    msg.getBytes(tmpMB);
                    epSecret = tmpMB.toString();
                }
                if (this.requiredSecret != null && this.requiredSecret.equals(epSecret)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Received wrong secret, no shutdown ");
                    }
                    return 2;
                }
                JkChannel ch = ep.getSource();
                if (!ch.isSameAddress(ep)) {
                    log.error((Object)"Shutdown request not from 'same address' ");
                    return 2;
                }
                if (!this.shutdownEnabled) {
                    log.warn((Object)"Ignoring shutdown request: shutdown not enabled");
                    return 2;
                }
                this.checkRequest(ep);
                this.next.invoke(msg, ep);
                log.info((Object)"Exiting");
                System.exit(0);
                return 0;
            }
            case 10: {
                msg.reset();
                msg.appendByte(9);
                ep.setType(11);
                ep.getSource().send(msg, ep);
                return 0;
            }
            case 13: {
                return 0;
            }
        }
        log.info((Object)("Unknown message " + type));
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Request checkRequest(MsgContext ep) {
        Request req = (Request)ep.getRequest();
        if (req == null) {
            req = new Request();
            Response res = new Response();
            req.setResponse(res);
            ep.setRequest(req);
            if (this.registerRequests) {
                Object object = lock;
                synchronized (object) {
                    ep.getSource().registerRequest(req, ep, count++);
                }
            }
        }
        return req;
    }

    private int decodeRequest(Msg msg, MsgContext ep, MessageBytes tmpMB) throws IOException {
        boolean isSSL;
        Request req = this.checkRequest(ep);
        RequestInfo rp = req.getRequestProcessor();
        rp.setStage(1);
        MessageBytes tmpMB2 = (MessageBytes)req.getNote(16);
        if (tmpMB2 != null) {
            tmpMB2.recycle();
        }
        req.setStartTime(System.currentTimeMillis());
        JkInputStream jkBody = (JkInputStream)ep.getNote(this.bodyNote);
        if (jkBody == null) {
            jkBody = new JkInputStream();
            jkBody.setMsgContext(ep);
            ep.setNote(this.bodyNote, jkBody);
        }
        jkBody.recycle();
        byte methodCode = msg.getByte();
        if (methodCode != -1) {
            String mName = methodTransArray[methodCode - 1];
            req.method().setString(mName);
        }
        msg.getBytes(req.protocol());
        msg.getBytes(req.requestURI());
        msg.getBytes(req.remoteAddr());
        msg.getBytes(req.remoteHost());
        msg.getBytes(req.localName());
        req.setLocalPort(msg.getInt());
        boolean bl = isSSL = msg.getByte() != 0;
        if (isSSL) {
            req.scheme().setString("https");
        }
        this.decodeHeaders(ep, msg, req, tmpMB);
        this.decodeAttributes(ep, msg, req, tmpMB);
        rp.setStage(2);
        MessageBytes valueMB = req.getMimeHeaders().getValue("host");
        this.parseHost(valueMB, req);
        req.getCookies().setHeaders(req.getMimeHeaders());
        int cl = req.getContentLength();
        if (cl > 0) {
            jkBody.setContentLength(cl);
            jkBody.receive();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)req.toString());
        }
        return 0;
    }

    private int decodeAttributes(MsgContext ep, Msg msg, Request req, MessageBytes tmpMB) {
        boolean moreAttr = true;
        while (moreAttr) {
            byte attributeCode = msg.getByte();
            if (attributeCode == -1) {
                return 200;
            }
            if (attributeCode == 11) {
                req.setAttribute("javax.servlet.request.key_size", (Object)new Integer(msg.getInt()));
            }
            if (attributeCode == 10) {
                msg.getBytes(tmpMB);
                String n = tmpMB.toString();
                msg.getBytes(tmpMB);
                String v = tmpMB.toString();
                req.setAttribute(n, (Object)v);
            }
            switch (attributeCode) {
                case 1: {
                    msg.getBytes(tmpMB);
                    break;
                }
                case 2: {
                    msg.getBytes(tmpMB);
                    break;
                }
                case 3: {
                    if (this.tomcatAuthentication) {
                        msg.getBytes(tmpMB);
                        break;
                    }
                    msg.getBytes(req.getRemoteUser());
                    break;
                }
                case 4: {
                    if (this.tomcatAuthentication) {
                        msg.getBytes(tmpMB);
                        break;
                    }
                    msg.getBytes(req.getAuthType());
                    break;
                }
                case 5: {
                    msg.getBytes(req.queryString());
                    break;
                }
                case 6: {
                    msg.getBytes(req.instanceId());
                    break;
                }
                case 7: {
                    req.scheme().setString("https");
                    MessageBytes tmpMB2 = (MessageBytes)req.getNote(16);
                    if (tmpMB2 == null) {
                        tmpMB2 = MessageBytes.newInstance();
                        req.setNote(16, (Object)tmpMB2);
                    }
                    msg.getBytes(tmpMB2);
                    break;
                }
                case 8: {
                    req.scheme().setString("https");
                    msg.getBytes(tmpMB);
                    req.setAttribute("javax.servlet.request.cipher_suite", (Object)tmpMB.toString());
                    break;
                }
                case 9: {
                    req.scheme().setString("https");
                    msg.getBytes(tmpMB);
                    req.setAttribute("javax.servlet.request.ssl_session", (Object)tmpMB.toString());
                    break;
                }
                case 12: {
                    msg.getBytes(tmpMB);
                    String secret = tmpMB.toString();
                    log.info((Object)("Secret: " + secret));
                    ep.setNote(this.secretNote, secret);
                    break;
                }
                case 13: {
                    msg.getBytes(req.method());
                    break;
                }
            }
        }
        return 200;
    }

    private void decodeHeaders(MsgContext ep, Msg msg, Request req, MessageBytes tmpMB) {
        MimeHeaders headers = req.getMimeHeaders();
        int hCount = msg.getInt();
        for (int i = 0; i < hCount; ++i) {
            String hName = null;
            int isc = msg.peekInt();
            int hId = isc & 0xFF;
            MessageBytes vMB = null;
            if (40960 == (isc &= 0xFF00)) {
                msg.getInt();
                hName = headerTransArray[hId - 1];
                vMB = headers.addValue(hName);
            } else {
                hId = -1;
                msg.getBytes(tmpMB);
                ByteChunk bc = tmpMB.getByteChunk();
                vMB = headers.addValue(bc.getBuffer(), bc.getStart(), bc.getLength());
            }
            msg.getBytes(vMB);
            if (hId == 8 || hId == -1 && tmpMB.equalsIgnoreCase("Content-Length")) {
                req.setContentLength(vMB.getInt());
                continue;
            }
            if (hId != 7 && (hId != -1 || !tmpMB.equalsIgnoreCase("Content-Type"))) continue;
            ByteChunk bchunk = vMB.getByteChunk();
            req.contentType().setBytes(bchunk.getBytes(), bchunk.getOffset(), bchunk.getLength());
        }
    }

    private void parseHost(MessageBytes valueMB, Request request) throws IOException {
        if (valueMB == null || valueMB.isNull()) {
            request.setServerPort(request.getLocalPort());
            request.serverName().duplicate(request.localName());
            return;
        }
        ByteChunk valueBC = valueMB.getByteChunk();
        byte[] valueB = valueBC.getBytes();
        int valueL = valueBC.getLength();
        int valueS = valueBC.getStart();
        int colonPos = -1;
        CharChunk hostNameC = (CharChunk)request.getNote(10);
        if (hostNameC == null) {
            hostNameC = new CharChunk(valueL);
            request.setNote(10, (Object)hostNameC);
        }
        hostNameC.recycle();
        boolean ipv6 = valueB[valueS] == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            char b = (char)valueB[i + valueS];
            hostNameC.append(b);
            if (b == ']') {
                bracketClosed = true;
                continue;
            }
            if (b != ':' || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            if (request.scheme().equalsIgnoreCase("https")) {
                request.setServerPort(443);
            } else {
                request.setServerPort(80);
            }
            request.serverName().setChars(hostNameC.getChars(), hostNameC.getStart(), hostNameC.getLength());
        } else {
            request.serverName().setChars(hostNameC.getChars(), hostNameC.getStart(), colonPos);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = HexUtils.DEC[valueB[i + valueS]];
                if (charValue == -1) {
                    throw new CharConversionException("Invalid char in port: " + valueB[i + valueS]);
                }
                port += charValue * mult;
                mult = 10 * mult;
            }
            request.setServerPort(port);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

