/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.cluster.CatalinaCluster;
import org.apache.catalina.cluster.ClusterManager;
import org.apache.catalina.cluster.ClusterMessage;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.session.DeltaRequest;
import org.apache.catalina.cluster.session.DeltaSession;
import org.apache.catalina.cluster.session.ReplicationStream;
import org.apache.catalina.cluster.session.SessionMessage;
import org.apache.catalina.cluster.session.SessionMessageImpl;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.util.CustomObjectInputStream;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeltaManager
extends ManagerBase
implements Lifecycle,
PropertyChangeListener,
ClusterManager {
    public static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$session$DeltaManager == null ? (class$org$apache$catalina$cluster$session$DeltaManager = DeltaManager.class$("org.apache.catalina.cluster.session.DeltaManager")) : class$org$apache$catalina$cluster$session$DeltaManager));
    private static final String info = "DeltaManager/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private int maxActiveSessions = -1;
    protected static String managerName = "DeltaManager";
    protected String name = null;
    private boolean started = false;
    int rejectedSessions = 0;
    int expiredSessions = 0;
    long processingTime = 0L;
    private CatalinaCluster cluster = null;
    private boolean stateTransferred;
    private boolean useDirtyFlag;
    private boolean expireSessionsOnShutdown;
    private boolean printToScreen;
    private boolean notifyListenersOnReplication = false;
    static /* synthetic */ Class class$org$apache$catalina$cluster$session$DeltaManager;

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.setContainer(container);
        if (this.container != null && this.container instanceof Context) {
            this.setMaxInactiveInterval(((Context)this.container).getSessionTimeout() * 60);
            ((Context)this.container).addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public String getInfo() {
        return info;
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public int getRejectedSessions() {
        return this.rejectedSessions;
    }

    public void setRejectedSessions(int rejectedSessions) {
        this.rejectedSessions = rejectedSessions;
    }

    public void setMaxActiveSessions(int max) {
        int oldMaxActiveSessions = this.maxActiveSessions;
        this.maxActiveSessions = max;
        this.support.firePropertyChange("maxActiveSessions", new Integer(oldMaxActiveSessions), new Integer(this.maxActiveSessions));
    }

    public String getName() {
        return this.name;
    }

    public Session createSession() {
        return this.createSession(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession(boolean distribute) {
        if (this.maxActiveSessions >= 0 && this.sessions.size() >= this.maxActiveSessions) {
            ++this.rejectedSessions;
            throw new IllegalStateException(sm.getString("standardManager.createSession.ise"));
        }
        DeltaSession session = this.getNewDeltaSession();
        String sessionId = this.generateSessionId();
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            while (this.sessions.get(sessionId) != null) {
                ++this.duplicates;
                sessionId = this.generateSessionId();
            }
        }
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        session.setId(sessionId);
        session.resetDeltaRequest();
        ++this.sessionCounter;
        if (distribute) {
            SessionMessageImpl msg = new SessionMessageImpl(this.getName(), 1, null, sessionId, sessionId + System.currentTimeMillis());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Manager (" + this.name + ") send new session (" + sessionId + ")"));
            }
            this.cluster.send(msg);
            session.resetDeltaRequest();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created a DeltaSession with Id[" + session.getId() + "] Total count=" + this.sessions.size()));
        }
        return session;
    }

    protected DeltaSession getNewDeltaSession() {
        return new DeltaSession(this);
    }

    private DeltaRequest loadDeltaRequest(DeltaSession session, byte[] data) throws ClassNotFoundException, IOException {
        ByteArrayInputStream fis = null;
        ReplicationStream ois = null;
        Loader loader = null;
        ClassLoader classLoader = null;
        if (this.container != null) {
            loader = this.container.getLoader();
        }
        classLoader = loader != null ? loader.getClassLoader() : Thread.currentThread().getContextClassLoader();
        fis = new ByteArrayInputStream(data);
        ois = new ReplicationStream(fis, classLoader);
        session.getDeltaRequest().readExternal(ois);
        ois.close();
        return session.getDeltaRequest();
    }

    private byte[] unloadDeltaRequest(DeltaRequest deltaRequest) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        deltaRequest.writeExternal(oos);
        oos.flush();
        oos.close();
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doLoad(byte[] data) throws ClassNotFoundException, IOException {
        ByteArrayInputStream fis = null;
        ObjectInputStream ois = null;
        Loader loader = null;
        ClassLoader classLoader = null;
        try {
            fis = new ByteArrayInputStream(data);
            BufferedInputStream bis = new BufferedInputStream(fis);
            if (this.container != null) {
                loader = this.container.getLoader();
            }
            if (loader != null) {
                classLoader = loader.getClassLoader();
            }
            ois = classLoader != null ? new CustomObjectInputStream((InputStream)bis, classLoader) : new ObjectInputStream(bis);
        }
        catch (IOException e) {
            log.error((Object)sm.getString("standardManager.loading.ioe", (Object)e), (Throwable)e);
            if (ois == null) throw e;
            try {
                ois.close();
            }
            catch (IOException f) {
                // empty catch block
            }
            ois = null;
            throw e;
        }
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            try {
                try {
                    Integer count = (Integer)ois.readObject();
                    int n = count;
                    for (int i = 0; i < n; ++i) {
                        DeltaSession session = this.getNewDeltaSession();
                        session.readObjectData(ois);
                        session.setManager(this);
                        session.setValid(true);
                        session.setPrimarySession(false);
                        session.access();
                        session.setAccessCount(0);
                        this.sessions.put(session.getId(), session);
                    }
                    Object var12_17 = null;
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)sm.getString("standardManager.loading.cnfe", (Object)e), (Throwable)e);
                    if (ois == null) throw e;
                    try {
                        ois.close();
                    }
                    catch (IOException f) {
                        // empty catch block
                    }
                    ois = null;
                    throw e;
                }
                catch (IOException e) {
                    log.error((Object)sm.getString("standardManager.loading.ioe", (Object)e), (Throwable)e);
                    if (ois == null) throw e;
                    try {
                        ois.close();
                    }
                    catch (IOException f) {
                        // empty catch block
                    }
                    ois = null;
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                try {
                    if (ois == null) throw throwable;
                    ois.close();
                    throw throwable;
                }
                catch (IOException f) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException f) {}
            if (ois == null) return;
            ois.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doUnload() throws IOException {
        ByteArrayOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(new BufferedOutputStream(fos));
        }
        catch (IOException e) {
            log.error((Object)sm.getString("standardManager.unloading.ioe", (Object)e), (Throwable)e);
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException f) {
                    // empty catch block
                }
                oos = null;
            }
            throw e;
        }
        ArrayList<DeltaSession> list = new ArrayList<DeltaSession>();
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            try {
                oos.writeObject(new Integer(this.sessions.size()));
                Iterator elements = this.sessions.values().iterator();
                while (elements.hasNext()) {
                    DeltaSession session = (DeltaSession)elements.next();
                    list.add(session);
                    session.writeObjectData(oos);
                }
                oos.flush();
                oos.close();
                oos = null;
            }
            catch (IOException e) {
                log.error((Object)sm.getString("standardManager.unloading.ioe", (Object)e), (Throwable)e);
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException f) {
                        // empty catch block
                    }
                    oos = null;
                }
                throw e;
            }
        }
        return fos.toByteArray();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        block15: {
            if (!this.initialized) {
                this.init();
            }
            if (this.started) {
                return;
            }
            this.started = true;
            this.lifecycle.fireLifecycleEvent("start", null);
            String dummy = this.generateSessionId();
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Starting clustering manager...:" + this.getName()));
                }
                if (this.cluster == null) {
                    log.error((Object)("Starting... no cluster associated with this context:" + this.getName()));
                    return;
                }
                this.getCluster().addManager(this.getName(), this);
                if (this.cluster.getMembers().length > 0) {
                    Member mbr = this.cluster.getMembers()[0];
                    SessionMessageImpl msg = new SessionMessageImpl(this.getName(), 4, null, "GET-ALL", "GET-ALL-" + this.getName());
                    this.cluster.send(msg, mbr);
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Manager[" + this.getName() + "], requesting session state from " + mbr + ". This operation will timeout if no session state has been received within " + "60 seconds"));
                    }
                    long reqStart = System.currentTimeMillis();
                    long reqNow = 0L;
                    boolean isTimeout = false;
                    do {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception sleep) {
                            // empty catch block
                        }
                        reqNow = System.currentTimeMillis();
                        boolean bl = isTimeout = reqNow - reqStart > 60000L;
                    } while (!this.getStateTransferred() && !isTimeout);
                    if (isTimeout || !this.getStateTransferred()) {
                        log.error((Object)("Manager[" + this.getName() + "], No session state received, timing out."));
                    } else if (log.isInfoEnabled()) {
                        log.info((Object)("Manager[" + this.getName() + "], session state received in " + (reqNow - reqStart) + " ms."));
                    }
                    break block15;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Manager[" + this.getName() + "], skipping state transfer. No members active in cluster group."));
                }
            }
            catch (Throwable t) {
                log.error((Object)sm.getString("standardManager.managerLoad"), t);
            }
        }
    }

    public void stop() throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Manager[" + this.getName() + "] is stopping"));
        }
        this.getCluster().removeManager(this.getName());
        if (!this.started) {
            throw new LifecycleException(sm.getString("standardManager.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (log.isInfoEnabled()) {
            log.info((Object)("Manager[" + this.getName() + "] Expiring sessions upon shutdown"));
        }
        Session[] sessions = this.findSessions();
        for (int i = 0; i < sessions.length; ++i) {
            DeltaSession session = (DeltaSession)sessions[i];
            if (!session.isValid()) continue;
            try {
                session.expire(true, this.getExpireSessionsOnShutdown());
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.random = null;
        if (this.initialized) {
            this.destroy();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        Context context = (Context)event.getSource();
        if (event.getPropertyName().equals("sessionTimeout")) {
            try {
                this.setMaxInactiveInterval((Integer)event.getNewValue() * 60);
            }
            catch (NumberFormatException e) {
                log.error((Object)sm.getString("standardManager.sessionTimeout", (Object)event.getNewValue().toString()));
            }
        }
    }

    public void messageDataReceived(ClusterMessage cmsg) {
        if (cmsg instanceof SessionMessage) {
            SessionMessage msg;
            this.messageReceived(msg, (msg = (SessionMessage)cmsg).getAddress() != null ? msg.getAddress() : null);
        }
    }

    public ClusterMessage requestCompleted(String sessionId) {
        try {
            long replDelta;
            DeltaSession session = (DeltaSession)this.findSession(sessionId);
            DeltaRequest deltaRequest = session.getDeltaRequest();
            SessionMessageImpl msg = null;
            if (deltaRequest.getSize() > 0) {
                byte[] data = this.unloadDeltaRequest(deltaRequest);
                msg = new SessionMessageImpl(this.name, 13, data, sessionId, sessionId + System.currentTimeMillis());
                session.resetDeltaRequest();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Manager (" + this.name + ") send session (" + sessionId + ") delta."));
                }
            } else if (!session.isPrimarySession()) {
                msg = new SessionMessageImpl(this.getName(), 3, null, sessionId, sessionId + System.currentTimeMillis());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Manager (" + this.name + ") send session (" + sessionId + ") access to change primary."));
                }
            }
            session.setPrimarySession(true);
            if (msg == null && (replDelta = System.currentTimeMillis() - session.getLastTimeReplicated()) > (long)(this.getMaxInactiveInterval() * 1000)) {
                msg = new SessionMessageImpl(this.getName(), 3, null, sessionId, sessionId + System.currentTimeMillis());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Manager (" + this.name + ") send session (" + sessionId + ") access."));
                }
            }
            if (msg != null) {
                session.setLastTimeReplicated(System.currentTimeMillis());
            }
            return msg;
        }
        catch (IOException x) {
            log.error((Object)"Unable to serialize delta request", (Throwable)x);
            return null;
        }
    }

    protected void sessionExpired(String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Manager (" + this.name + ") send session (" + id + ") expired."));
        }
        SessionMessageImpl msg = new SessionMessageImpl(this.getName(), 2, null, id, id + "-EXPIRED-MSG");
        this.cluster.send(msg);
    }

    public String[] getInvalidatedSessions() {
        return new String[0];
    }

    protected void messageReceived(SessionMessage msg, Member sender) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Manager (" + this.name + ") Received SessionMessage of type=" + msg.getEventTypeString() + " from " + sender));
            }
            switch (msg.getEventType()) {
                case 4: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Manager (" + this.name + ") unloading sessions"));
                    }
                    byte[] data = this.doUnload();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Manager (" + this.name + ") unloading sessions complete"));
                    }
                    SessionMessageImpl newmsg = new SessionMessageImpl(this.name, 12, data, "SESSION-STATE", "SESSION-STATE-" + this.getName());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Manager (" + this.name + ") send all session data."));
                    }
                    this.cluster.send(newmsg, sender);
                    break;
                }
                case 12: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Manager (" + this.name + ") received session state data."));
                    }
                    byte[] data = msg.getSession();
                    this.doLoad(data);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Manager (" + this.name + ") state deserialized."));
                    }
                    this.stateTransferred = true;
                    break;
                }
                case 1: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Manager (" + this.name + ") received session (" + msg.getSessionID() + ") created."));
                    }
                    DeltaSession session = (DeltaSession)this.createSession(false);
                    session.setId(msg.getSessionID());
                    session.setNew(false);
                    session.setPrimarySession(false);
                    session.resetDeltaRequest();
                    break;
                }
                case 2: {
                    DeltaSession session = (DeltaSession)this.findSession(msg.getSessionID());
                    if (session == null) break;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Manager (" + this.name + ") received session (" + msg.getSessionID() + ") expired."));
                    }
                    session.expire(true, false);
                    break;
                }
                case 3: {
                    DeltaSession session = (DeltaSession)this.findSession(msg.getSessionID());
                    if (session == null) break;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Manager (" + this.name + ") received session (" + msg.getSessionID() + ") accessed."));
                    }
                    session.access();
                    session.setPrimarySession(false);
                    session.endAccess();
                    break;
                }
                case 13: {
                    byte[] delta = msg.getSession();
                    DeltaSession session = (DeltaSession)this.findSession(msg.getSessionID());
                    if (session == null) break;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Manager (" + this.name + ") received session (" + msg.getSessionID() + ") delta."));
                    }
                    DeltaRequest dreq = this.loadDeltaRequest(session, delta);
                    dreq.execute(session, this.notifyListenersOnReplication);
                    session.setPrimarySession(false);
                    break;
                }
            }
        }
        catch (Exception x) {
            log.error((Object)"Unable to receive message through TCP channel", (Throwable)x);
        }
    }

    public boolean getStateTransferred() {
        return this.stateTransferred;
    }

    public void setStateTransferred(boolean stateTransferred) {
        this.stateTransferred = stateTransferred;
    }

    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    public void setCluster(CatalinaCluster cluster) {
        this.cluster = cluster;
    }

    public void load() {
    }

    public void unload() {
    }

    public boolean getUseDirtyFlag() {
        return this.useDirtyFlag;
    }

    public void setUseDirtyFlag(boolean useDirtyFlag) {
        this.useDirtyFlag = useDirtyFlag;
    }

    public boolean getExpireSessionsOnShutdown() {
        return this.expireSessionsOnShutdown;
    }

    public void setExpireSessionsOnShutdown(boolean expireSessionsOnShutdown) {
        this.expireSessionsOnShutdown = expireSessionsOnShutdown;
    }

    public boolean getPrintToScreen() {
        return this.printToScreen;
    }

    public void setPrintToScreen(boolean printToScreen) {
        this.printToScreen = printToScreen;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getNotifyListenersOnReplication() {
        return this.notifyListenersOnReplication;
    }

    public void setNotifyListenersOnReplication(boolean notifyListenersOnReplication) {
        this.notifyListenersOnReplication = notifyListenersOnReplication;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

