/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.session;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.cluster.CatalinaCluster;
import org.apache.catalina.cluster.session.DeltaManager;
import org.apache.catalina.cluster.session.DeltaSession;
import org.apache.catalina.cluster.session.SessionIDMessage;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JvmRouteBinderValve
extends ValveBase
implements Lifecycle {
    public static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$session$JvmRouteBinderValve == null ? (class$org$apache$catalina$cluster$session$JvmRouteBinderValve = JvmRouteBinderValve.class$("org.apache.catalina.cluster.session.JvmRouteBinderValve")) : class$org$apache$catalina$cluster$session$JvmRouteBinderValve));
    protected static final String info = "org.apache.catalina.session.JvmRouteBinderValve/1.0";
    protected CatalinaCluster cluster;
    protected Manager manager;
    protected boolean managerCheck = false;
    protected StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster.session");
    protected boolean started = false;
    protected boolean enabled = true;
    protected long numberOfSessions = 0L;
    protected String sessionIdAttribute = "JvmRouteOrignalSessionID";
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    static /* synthetic */ Class class$org$apache$catalina$cluster$session$JvmRouteBinderValve;

    public String getInfo() {
        return info;
    }

    public String getSessionIdAttribute() {
        return this.sessionIdAttribute;
    }

    public void setSessionIdAttribute(String sessionIdAttribute) {
        this.sessionIdAttribute = sessionIdAttribute;
    }

    public long getNumberOfSessions() {
        return this.numberOfSessions;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getManager();
        if (this.getEnabled() && this.manager != null) {
            this.handlePossibleTurnover(request, response);
        }
        this.getNext().invoke(request, response);
    }

    protected void handlePossibleTurnover(Request request, Response response) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            long t1 = System.currentTimeMillis();
            String jvmRoute = this.getLocalJvmRoute();
            if (jvmRoute == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"No engine jvmRoute!");
                }
                return;
            }
            if (request.isRequestedSessionIdFromURL()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Skip reassign jvm route check, sessionid comes from URL!");
                }
            } else {
                this.handleJvmRoute(session.getId(), jvmRoute, request, response);
            }
            if (log.isInfoEnabled()) {
                long t2 = System.currentTimeMillis();
                long time = t2 - t1;
                if (log.isInfoEnabled()) {
                    log.info((Object)("Turnover Check time " + time + "msec"));
                }
            }
        }
    }

    protected String getLocalJvmRoute() {
        return ((ManagerBase)this.manager).getJvmRoute();
    }

    protected Manager getManager() {
        if (!this.managerCheck) {
            this.managerCheck = true;
            if (this.container.getManager() instanceof DeltaManager) {
                this.manager = this.container.getManager();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found Cluster DeltaManager " + this.container.getManager() + " at " + this.getContainer().getName()));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No Cluster DeltaManager " + this.container.getManager() + " at " + this.getContainer().getName()));
            }
        }
        return this.manager;
    }

    protected void handleJvmRoute(String sessionId, String localJvmRoute, Request request, Response response) {
        String requestJvmRoute = null;
        int index = sessionId.indexOf(".");
        if (index > 0) {
            requestJvmRoute = sessionId.substring(index + 1, sessionId.length());
        }
        if (requestJvmRoute != null && !requestJvmRoute.equals(localJvmRoute)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("We have detected a failover with differen jvmRoute. old one: " + requestJvmRoute + " new one: " + localJvmRoute + ". Will reset the session id."));
            }
            String newSessionID = sessionId.substring(0, index) + "." + localJvmRoute;
            Session catalinaSession = null;
            try {
                catalinaSession = this.manager.findSession(sessionId);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (catalinaSession != null) {
                this.changeSessionID(sessionId, request, response, newSessionID, catalinaSession);
                ++this.numberOfSessions;
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to find session= [" + sessionId + "]"));
            }
        }
    }

    protected void changeSessionID(String sessionId, Request request, Response response, String newSessionID, Session catalinaSession) {
        this.lifecycle.fireLifecycleEvent("Before session migration", (Object)catalinaSession);
        request.setRequestedSessionId(newSessionID);
        catalinaSession.setId(newSessionID);
        if (catalinaSession instanceof DeltaSession) {
            ((DeltaSession)catalinaSession).resetDeltaRequest();
        }
        this.setNewSessionCookie(newSessionID, request, response);
        if (this.sessionIdAttribute != null && !"".equals(this.sessionIdAttribute)) {
            request.setAttribute(this.sessionIdAttribute, (Object)sessionId);
        }
        this.sendSessionIDClusterBackup(sessionId, newSessionID);
        this.lifecycle.fireLifecycleEvent("After session migration", (Object)catalinaSession);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Changed catalina session to= [" + newSessionID + "] old one= [" + sessionId + "]"));
        }
    }

    protected void sendSessionIDClusterBackup(String sessionId, String newSessionID) {
        SessionIDMessage msg = new SessionIDMessage();
        msg.setOrignalSessionID(sessionId);
        msg.setBackupSessionID(newSessionID);
        Context context = (Context)this.getContainer();
        msg.setContextPath(context.getPath());
        this.cluster.send(msg);
    }

    protected void setNewSessionCookie(String sessionId, Request request, Response response) {
        Context context;
        if (response != null && (context = (Context)this.getContainer()).getCookies()) {
            Cookie newCookie = new Cookie("JSESSIONID", sessionId);
            newCookie.setMaxAge(-1);
            String contextPath = null;
            if (!response.getConnector().getEmptySessionPath() && context != null) {
                contextPath = context.getEncodedPath();
            }
            if (contextPath != null && contextPath.length() > 0) {
                newCookie.setPath(contextPath);
            } else {
                newCookie.setPath("/");
            }
            if (request.isSecure()) {
                newCookie.setSecure(true);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting cookie with session id:" + sessionId + " & name: " + "JSESSIONID" + " & path: " + newCookie.getPath() + " & secure: " + newCookie.getSecure()));
            }
            response.addCookie(newCookie);
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("jvmRoute.valve.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        Container container = this.getContainer().getParent();
        if (container instanceof Host && ((Host)container).getCluster() != null) {
            this.cluster = (CatalinaCluster)((Host)container).getCluster();
        }
        if (this.cluster == null) {
            throw new RuntimeException("No clustering support at container " + container.getName());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"JvmRouteBinderValve started");
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("jvmRoute.valve.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.cluster = null;
        this.manager = null;
        this.managerCheck = false;
        this.numberOfSessions = 0L;
        if (log.isInfoEnabled()) {
            log.info((Object)"JvmRouteBinderValve stopped)");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

