/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.session;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.cluster.CatalinaCluster;
import org.apache.catalina.cluster.MessageListener;
import org.apache.catalina.cluster.session.JvmRouteSessionIDBinderListener;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.Registry;

public class JvmRouteSessionIDBinderLifecycleListener
implements LifecycleListener {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$session$JvmRouteSessionIDBinderLifecycleListener == null ? (class$org$apache$catalina$cluster$session$JvmRouteSessionIDBinderLifecycleListener = JvmRouteSessionIDBinderLifecycleListener.class$("org.apache.catalina.cluster.session.JvmRouteSessionIDBinderLifecycleListener")) : class$org$apache$catalina$cluster$session$JvmRouteSessionIDBinderLifecycleListener));
    private static final String info = "org.apache.catalina.cluster.session.JvmRouteSessionIDBinderLifecycleListener/1.0";
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster.session");
    private boolean enabled = true;
    private MBeanServer mserver = null;
    private Registry registry = null;
    private MessageListener sessionMoverListener;
    static /* synthetic */ Class class$org$apache$catalina$cluster$session$JvmRouteSessionIDBinderLifecycleListener;

    public void lifecycleEvent(LifecycleEvent event) {
        if (this.enabled && event.getSource() instanceof StandardHost) {
            if ("after_start".equals(event.getType())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SessionID Binder Listener started");
                }
                this.startSessionIDListener((StandardHost)event.getSource());
            } else if ("before_stop".equals(event.getType())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SessionID Binder Listener stopped");
                }
                this.stopSessionIDListener((StandardHost)event.getSource());
            }
        }
    }

    protected void stopSessionIDListener(StandardHost host) {
        if (this.sessionMoverListener != null) {
            CatalinaCluster cluster = (CatalinaCluster)host.getCluster();
            cluster.removeClusterListener(this.sessionMoverListener);
            if (this.mserver != null) {
                try {
                    ObjectName objectName = this.getObjectName(host);
                    this.mserver.unregisterMBean(objectName);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
    }

    protected ObjectName getObjectName(StandardHost host) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectName(host.getDomain() + ":type=Listener,name=JvmRouteSessionIDBinderListener,host=" + host.getName());
        return objectName;
    }

    protected void startSessionIDListener(StandardHost host) {
        try {
            ObjectName objectName = null;
            this.getMBeanServer();
            objectName = this.getObjectName(host);
            if (this.mserver.isRegistered(objectName)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)sm.getString("jvmRoute.run.already"));
                }
                return;
            }
            this.sessionMoverListener = new JvmRouteSessionIDBinderListener();
            this.mserver.registerMBean(this.getManagedBean(this.sessionMoverListener), objectName);
            CatalinaCluster cluster = (CatalinaCluster)host.getCluster();
            this.sessionMoverListener.setCluster(cluster);
            ((JvmRouteSessionIDBinderListener)this.sessionMoverListener).start();
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected MBeanServer getMBeanServer() throws Exception {
        if (this.mserver == null) {
            this.mserver = MBeanServerFactory.findMBeanServer(null).size() > 0 ? MBeanServerFactory.findMBeanServer(null).get(0) : MBeanServerFactory.createMBeanServer();
            this.registry = Registry.getRegistry(null, null);
            this.registry.loadMetadata((Object)this.getClass().getResourceAsStream("mbeans-descriptors.xml"));
        }
        return this.mserver;
    }

    protected ModelMBean getManagedBean(Object object) throws Exception {
        ModelMBean mbean = null;
        if (this.registry != null) {
            ManagedBean managedBean = this.registry.findManagedBean(object.getClass().getName());
            mbean = managedBean.createMBean(object);
        }
        return mbean;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getInfo() {
        return info;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

