/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.session;

import java.io.IOException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.cluster.CatalinaCluster;
import org.apache.catalina.cluster.ClusterMessage;
import org.apache.catalina.cluster.MessageListener;
import org.apache.catalina.cluster.session.SessionIDMessage;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JvmRouteSessionIDBinderListener
implements MessageListener {
    public static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$session$JvmRouteSessionIDBinderListener == null ? (class$org$apache$catalina$cluster$session$JvmRouteSessionIDBinderListener = JvmRouteSessionIDBinderListener.class$("org.apache.catalina.cluster.session.JvmRouteSessionIDBinderListener")) : class$org$apache$catalina$cluster$session$JvmRouteSessionIDBinderListener));
    protected static final String info = "org.apache.catalina.session.JvmRouteSessionIDBinderListener/1.0";
    private StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster.session");
    protected CatalinaCluster cluster = null;
    protected boolean started = false;
    private long numberOfSessions = 0L;
    static /* synthetic */ Class class$org$apache$catalina$cluster$session$JvmRouteSessionIDBinderListener;

    public String getInfo() {
        return info;
    }

    public long getNumberOfSessions() {
        return this.numberOfSessions;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        this.getCluster().addClusterListener(this);
        this.started = true;
        if (log.isInfoEnabled()) {
            log.info((Object)"Cluster JvmRouteSessionIDBinderListener started.");
        }
    }

    public void stop() throws LifecycleException {
        this.started = false;
        this.getCluster().removeClusterListener(this);
        if (log.isInfoEnabled()) {
            log.info((Object)"Cluster JvmRouteSessionIDBinderListener stopped.");
        }
    }

    public void messageReceived(ClusterMessage msg) {
        if (msg instanceof SessionIDMessage && msg != null) {
            Container host;
            SessionIDMessage sessionmsg = (SessionIDMessage)msg;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cluster JvmRouteSessionIDBinderListener received session ID " + sessionmsg.getOrignalSessionID() + " set to " + sessionmsg.getBackupSessionID() + " for context path" + sessionmsg.getContextPath()));
            }
            if ((host = this.getCluster().getContainer()) != null) {
                Context context = (Context)host.findChild(sessionmsg.getContextPath());
                if (context != null) {
                    try {
                        Session session = context.getManager().findSession(sessionmsg.getOrignalSessionID());
                        if (session != null) {
                            session.setId(sessionmsg.getBackupSessionID());
                        } else if (log.isInfoEnabled()) {
                            log.info((Object)("Lost Session " + sessionmsg.getOrignalSessionID()));
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                    }
                } else if (log.isErrorEnabled()) {
                    log.error((Object)("Context " + sessionmsg.getContextPath() + "not found at " + ((StandardEngine)host.getParent()).getJvmRoute() + "!"));
                }
            } else if (log.isErrorEnabled()) {
                log.error((Object)("No host found " + sessionmsg.getContextPath()));
            }
        }
    }

    public boolean accept(ClusterMessage msg) {
        return msg instanceof SessionIDMessage;
    }

    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    public void setCluster(CatalinaCluster cluster) {
        this.cluster = cluster;
    }

    public boolean equals(Object listener) {
        return super.equals(listener);
    }

    public int hashCode() {
        return super.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

