/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.catalina.cluster.tcp.IDataSender;
import org.apache.catalina.cluster.util.SmartQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncSocketSender
implements IDataSender {
    private static int threadCounter = 1;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$AsyncSocketSender == null ? (class$org$apache$catalina$cluster$tcp$AsyncSocketSender = AsyncSocketSender.class$("org.apache.catalina.cluster.tcp.AsyncSocketSender")) : class$org$apache$catalina$cluster$tcp$AsyncSocketSender));
    private InetAddress address;
    private int port;
    private Socket sc = null;
    private boolean isSocketConnected = false;
    private SmartQueue queue = new SmartQueue();
    private boolean suspect;
    private QueueThread queueThread = null;
    private long ackTimeout;
    private long nrOfRequests = 0L;
    private long totalBytes = 0L;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$AsyncSocketSender;

    private synchronized void addStats(int length) {
        ++this.nrOfRequests;
        this.totalBytes += (long)length;
        if (log.isDebugEnabled() && this.nrOfRequests % 100L == 0L) {
            log.debug((Object)("Send stats from " + this.getAddress().getHostAddress() + ":" + this.getPort() + "Nr of bytes sent=" + this.totalBytes + " over " + this.nrOfRequests + " ==" + this.totalBytes / this.nrOfRequests + " bytes/request"));
        }
    }

    public long getNrOfRequests() {
        return this.nrOfRequests;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public AsyncSocketSender(InetAddress host, int port) {
        this.address = host;
        this.port = port;
        this.checkThread();
        if (log.isInfoEnabled()) {
            log.info((Object)"Started async sender thread for TCP replication.");
        }
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public void connect() throws IOException {
        this.sc = new Socket(this.getAddress(), this.getPort());
        this.isSocketConnected = true;
        this.checkThread();
    }

    protected void checkThread() {
        if (this.queueThread == null) {
            this.queueThread = new QueueThread(this);
            this.queueThread.setDaemon(true);
            this.queueThread.start();
        }
    }

    public void disconnect() {
        try {
            this.sc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isSocketConnected = false;
        if (this.queueThread != null) {
            this.queueThread.stopRunning();
            this.queueThread = null;
        }
    }

    public boolean isConnected() {
        return this.isSocketConnected;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    private synchronized void sendMessage(byte[] data) throws IOException {
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            this.sc.getOutputStream().write(data);
            this.sc.getOutputStream().flush();
        }
        catch (IOException x) {
            this.disconnect();
            this.connect();
            this.sc.getOutputStream().write(data);
            this.sc.getOutputStream().flush();
        }
        this.addStats(data.length);
    }

    public synchronized void sendMessage(String sessionId, byte[] data) throws IOException {
        SmartQueue.SmartEntry entry = new SmartQueue.SmartEntry(sessionId, data);
        this.queue.add(entry);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("AsyncSocketSender[");
        buf.append(this.getAddress()).append(":").append(this.getPort()).append("]");
        return buf.toString();
    }

    public boolean isSuspect() {
        return this.suspect;
    }

    public boolean getSuspect() {
        return this.suspect;
    }

    public void setSuspect(boolean suspect) {
        this.suspect = suspect;
    }

    public long getAckTimeout() {
        return this.ackTimeout;
    }

    public void setAckTimeout(long ackTimeout) {
        this.ackTimeout = ackTimeout;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class QueueThread
    extends Thread {
        AsyncSocketSender sender;
        private boolean keepRunning = true;

        public QueueThread(AsyncSocketSender sender) {
            this.sender = sender;
            this.setName("Cluster-AsyncSocketSender-" + threadCounter++);
        }

        public void stopRunning() {
            this.keepRunning = false;
        }

        public void run() {
            while (this.keepRunning) {
                SmartQueue.SmartEntry entry = this.sender.queue.remove(5000L);
                if (entry == null) continue;
                try {
                    byte[] data = (byte[])entry.getValue();
                    this.sender.sendMessage(data);
                }
                catch (Exception x) {
                    log.warn((Object)("Unable to asynchronously send session w/ id=" + entry.getKey() + " message will be ignored."));
                }
            }
        }
    }
}

