/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.LinkedList;
import org.apache.catalina.cluster.tcp.IDataSender;
import org.apache.catalina.cluster.tcp.SocketSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PooledSocketSender
implements IDataSender {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$CatalinaCluster == null ? (class$org$apache$catalina$cluster$CatalinaCluster = PooledSocketSender.class$("org.apache.catalina.cluster.CatalinaCluster")) : class$org$apache$catalina$cluster$CatalinaCluster));
    private InetAddress address;
    private int port;
    private Socket sc = null;
    private boolean isSocketConnected = true;
    private boolean suspect;
    private long ackTimeout = 15000L;
    private long keepAliveTimeout = 60000L;
    private int keepAliveMaxRequestCount = 100;
    private long keepAliveConnectTime = 0L;
    private int keepAliveCount = 0;
    private int maxPoolSocketLimit = 25;
    private SenderQueue senderQueue = null;
    private long nrOfRequests = 0L;
    private long totalBytes = 0L;
    static /* synthetic */ Class class$org$apache$catalina$cluster$CatalinaCluster;

    public PooledSocketSender(InetAddress host, int port) {
        this.address = host;
        this.port = port;
        this.senderQueue = new SenderQueue(this, this.maxPoolSocketLimit);
    }

    private synchronized void addStats(int length) {
        ++this.nrOfRequests;
        this.totalBytes += (long)length;
        if (log.isDebugEnabled() && this.nrOfRequests % 100L == 0L) {
            log.debug((Object)("Send stats from " + this.getAddress().getHostAddress() + ":" + this.getPort() + "Nr of bytes sent=" + this.totalBytes + " over " + this.nrOfRequests + " ==" + this.totalBytes / this.nrOfRequests + " bytes/request"));
        }
    }

    public long getNrOfRequests() {
        return this.nrOfRequests;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public void connect() throws IOException {
        this.senderQueue.open();
        this.isSocketConnected = true;
    }

    public void disconnect() {
        this.senderQueue.close();
        this.isSocketConnected = false;
    }

    public boolean isConnected() {
        return this.isSocketConnected;
    }

    public void setAckTimeout(long timeout) {
        this.ackTimeout = timeout;
    }

    public long getAckTimeout() {
        return this.ackTimeout;
    }

    public void setMaxPoolSocketLimit(int limit) {
        this.maxPoolSocketLimit = limit;
    }

    public int getMaxPoolSocketLimit() {
        return this.maxPoolSocketLimit;
    }

    public void sendMessage(String sessionId, byte[] data) throws IOException {
        SocketSender sender = this.senderQueue.getSender(0L);
        if (sender == null) {
            log.warn((Object)("No socket sender available for client=" + this.getAddress() + ":" + this.getPort() + " did it disappear?"));
            return;
        }
        sender.sendMessage(sessionId, data);
        this.senderQueue.returnSender(sender);
        this.addStats(data.length);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("PooledSocketSender[");
        buf.append(this.getAddress()).append(":").append(this.getPort()).append("]");
        return buf.toString();
    }

    public boolean getSuspect() {
        return this.suspect;
    }

    public void setSuspect(boolean suspect) {
        this.suspect = suspect;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(long keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public int getKeepAliveMaxRequestCount() {
        return this.keepAliveMaxRequestCount;
    }

    public void setKeepAliveMaxRequestCount(int keepAliveMaxRequestCount) {
        this.keepAliveMaxRequestCount = keepAliveMaxRequestCount;
    }

    public long getKeepAliveConnectTime() {
        return this.keepAliveConnectTime;
    }

    public int getKeepAliveCount() {
        return this.keepAliveCount;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SenderQueue {
        private int limit = 25;
        PooledSocketSender parent = null;
        private LinkedList queue = new LinkedList();
        private LinkedList inuse = new LinkedList();
        private Object mutex = new Object();
        private boolean isOpen = true;

        public SenderQueue(PooledSocketSender parent, int limit) {
            this.limit = limit;
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SocketSender getSender(long timeout) {
            SocketSender sender = null;
            long start = System.currentTimeMillis();
            long delta = 0L;
            do {
                Object object = this.mutex;
                synchronized (object) {
                    if (!this.isOpen) {
                        throw new IllegalStateException("Socket pool is closed.");
                    }
                    if (this.queue.size() > 0) {
                        sender = (SocketSender)this.queue.removeFirst();
                    } else if (this.inuse.size() < this.limit) {
                        sender = this.getNewSocketSender();
                    } else {
                        try {
                            this.mutex.wait(timeout);
                        }
                        catch (Exception x) {
                            log.warn((Object)"PoolSocketSender.senderQueue.getSender failed", (Throwable)x);
                        }
                    }
                    if (sender != null) {
                        this.inuse.add(sender);
                    }
                }
                delta = System.currentTimeMillis() - start;
            } while (this.isOpen && sender == null && (timeout == 0L || delta < timeout));
            return sender;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void returnSender(SocketSender sender) {
            Object object = this.mutex;
            synchronized (object) {
                this.queue.add(sender);
                this.inuse.remove(sender);
                this.mutex.notify();
            }
        }

        private SocketSender getNewSocketSender() {
            SocketSender sender = new SocketSender(this.parent.getAddress(), this.parent.getPort());
            sender.setKeepAliveMaxRequestCount(this.parent.getKeepAliveMaxRequestCount());
            sender.setKeepAliveTimeout(this.parent.getKeepAliveTimeout());
            sender.setAckTimeout(this.parent.getAckTimeout());
            return sender;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.mutex;
            synchronized (object) {
                SocketSender sender;
                int i;
                for (i = 0; i < this.queue.size(); ++i) {
                    sender = (SocketSender)this.queue.get(i);
                    sender.disconnect();
                }
                for (i = 0; i < this.inuse.size(); ++i) {
                    sender = (SocketSender)this.inuse.get(i);
                    sender.disconnect();
                }
                this.queue.clear();
                this.inuse.clear();
                this.isOpen = false;
                this.mutex.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void open() {
            Object object = this.mutex;
            synchronized (object) {
                this.isOpen = true;
                this.mutex.notifyAll();
            }
        }
    }
}

