/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.cluster.ClusterSender;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.io.XByteBuffer;
import org.apache.catalina.cluster.tcp.IDataSender;
import org.apache.catalina.cluster.tcp.IDataSenderFactory;
import org.apache.catalina.cluster.tcp.SimpleTcpCluster;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReplicationTransmitter
implements ClusterSender {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$ReplicationTransmitter == null ? (class$org$apache$catalina$cluster$tcp$ReplicationTransmitter = ReplicationTransmitter.class$("org.apache.catalina.cluster.tcp.ReplicationTransmitter")) : class$org$apache$catalina$cluster$tcp$ReplicationTransmitter));
    protected StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster");
    private HashMap map = new HashMap();
    private long nrOfRequests = 0L;
    private long totalBytes = 0L;
    private String replicationMode;
    private long ackTimeout = 15000L;
    private SimpleTcpCluster cluster;
    private ObjectName objectName;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$ReplicationTransmitter;

    private synchronized void addStats(int length) {
        ++this.nrOfRequests;
        this.totalBytes += (long)length;
        if (log.isDebugEnabled() && this.nrOfRequests % 100L == 0L) {
            log.debug((Object)("Nr of bytes sent=" + this.totalBytes + " over " + this.nrOfRequests + " ==" + this.totalBytes / this.nrOfRequests + " bytes/request"));
        }
    }

    public long getNrOfRequests() {
        return this.nrOfRequests;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public void setReplicationMode(String mode) {
        String msg = IDataSenderFactory.validateMode(mode);
        if (msg == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting replcation mode to " + mode));
            }
        } else {
            throw new IllegalArgumentException(msg);
        }
        this.replicationMode = mode;
    }

    public synchronized void add(Member member) {
        try {
            String key = this.getKey(member);
            if (!this.map.containsKey(key)) {
                IDataSender sender = IDataSenderFactory.getIDataSender(this.replicationMode, member);
                this.map.put(key, sender);
                this.registerSenderMBean(member, sender);
            }
        }
        catch (IOException x) {
            log.error((Object)"Unable to create and add a IDataSender object.", (Throwable)x);
        }
    }

    private String getKey(Member member) {
        return member.getHost() + ":" + member.getPort();
    }

    public synchronized void remove(Member member) {
        String key = this.getKey(member);
        IDataSender toberemoved = (IDataSender)this.map.get(key);
        if (toberemoved == null) {
            return;
        }
        this.unregisterSenderMBean(toberemoved);
        toberemoved.disconnect();
        this.map.remove(key);
    }

    protected void unregisterSenderMBean(IDataSender sender) {
        try {
            MBeanServer mserver = this.cluster.getMBeanServer();
            if (mserver != null) {
                mserver.unregisterMBean(this.getSenderObjectName(sender));
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void registerSenderMBean(Member member, IDataSender sender) {
        if (member != null && this.cluster != null) {
            try {
                MBeanServer mserver = this.cluster.getMBeanServer();
                ObjectName senderName = this.getSenderObjectName(sender);
                if (mserver.isRegistered(senderName)) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)this.sm.getString("cluster.mbean.register.allready", (Object)senderName));
                    }
                    return;
                }
                mserver.registerMBean(this.cluster.getManagedBean(sender), senderName);
            }
            catch (Exception e) {
                log.warn((Object)e);
            }
        }
    }

    protected ObjectName getSenderObjectName(IDataSender sender) {
        ObjectName senderName = null;
        try {
            ObjectName clusterName = this.cluster.getObjectName();
            MBeanServer mserver = this.cluster.getMBeanServer();
            senderName = new ObjectName(clusterName.getDomain() + ":type=IDataSender,host=" + clusterName.getKeyProperty("host") + ",senderAddress=" + sender.getAddress().getHostAddress() + ",senderPort=" + sender.getPort());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        return senderName;
    }

    public void start() throws IOException {
        if (this.cluster != null) {
            ObjectName clusterName = this.cluster.getObjectName();
            try {
                MBeanServer mserver = this.cluster.getMBeanServer();
                ObjectName transmitterName = new ObjectName(clusterName.getDomain() + ":type=ClusterSender,host=" + clusterName.getKeyProperty("host"));
                if (mserver.isRegistered(transmitterName)) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)this.sm.getString("cluster.mbean.register.allready", (Object)transmitterName));
                    }
                    return;
                }
                this.setObjectName(transmitterName);
                mserver.registerMBean(this.cluster.getManagedBean(this), this.getObjectName());
            }
            catch (Exception e) {
                log.warn((Object)e);
            }
        }
    }

    public void setObjectName(ObjectName name) {
        this.objectName = name;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public synchronized void stop() {
        Iterator i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            IDataSender sender = (IDataSender)i.next().getValue();
            try {
                this.unregisterSenderMBean(sender);
                sender.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            i.remove();
        }
        if (this.cluster != null && this.getObjectName() != null) {
            try {
                MBeanServer mserver = this.cluster.getMBeanServer();
                mserver.unregisterMBean(this.getObjectName());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public IDataSender[] getSenders() {
        Iterator i = this.map.entrySet().iterator();
        Vector<IDataSender> v = new Vector<IDataSender>();
        while (i.hasNext()) {
            IDataSender sender = (IDataSender)i.next().getValue();
            if (sender == null) continue;
            v.addElement(sender);
        }
        Object[] result = new IDataSender[v.size()];
        v.copyInto(result);
        return result;
    }

    protected void sendMessageData(String sessionId, byte[] data, IDataSender sender) throws IOException {
        if (sender == null) {
            throw new IOException("Sender not available. Make sure sender information is available to the ReplicationTransmitter.");
        }
        try {
            if (!sender.isConnected()) {
                sender.connect();
            }
            sender.setAckTimeout(this.getAckTimeout());
            sender.sendMessage(sessionId, data);
            sender.setSuspect(false);
            this.addStats(data.length);
        }
        catch (Exception x) {
            if (log.isWarnEnabled() && !sender.getSuspect()) {
                log.warn((Object)"Unable to send replicated message, is server down?", (Throwable)x);
            }
            sender.setSuspect(true);
        }
    }

    public void sendMessage(String sessionId, byte[] indata, Member member) throws IOException {
        byte[] data = XByteBuffer.createDataPackage(indata);
        String key = this.getKey(member);
        IDataSender sender = (IDataSender)this.map.get(key);
        this.sendMessageData(sessionId, data, sender);
    }

    public void sendMessage(String sessionId, byte[] indata) throws IOException {
        IDataSender[] senders = this.getSenders();
        byte[] data = XByteBuffer.createDataPackage(indata);
        for (int i = 0; i < senders.length; ++i) {
            IDataSender sender = senders[i];
            try {
                this.sendMessageData(sessionId, data, sender);
                continue;
            }
            catch (Exception x) {
                if (!sender.getSuspect()) {
                    log.warn((Object)("Unable to send replicated message to " + sender + ", is server down?"), (Throwable)x);
                }
                sender.setSuspect(true);
            }
        }
    }

    public String getReplicationMode() {
        return this.replicationMode;
    }

    public boolean getIsSenderSynchronized() {
        return "synchronous".equals(this.replicationMode) || "pooled".equals(this.replicationMode);
    }

    public long getAckTimeout() {
        return this.ackTimeout;
    }

    public void setAckTimeout(long ackTimeout) {
        this.ackTimeout = ackTimeout;
    }

    public void setCatalinaCluster(SimpleTcpCluster cluster) {
        this.cluster = cluster;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

