/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.catalina.cluster.tcp.IDataSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SocketSender
implements IDataSender {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$SocketSender == null ? (class$org$apache$catalina$cluster$tcp$SocketSender = SocketSender.class$("org.apache.catalina.cluster.tcp.SocketSender")) : class$org$apache$catalina$cluster$tcp$SocketSender));
    private InetAddress address;
    private int port;
    private Socket sc = null;
    private boolean isSocketConnected = false;
    private boolean suspect;
    private long ackTimeout = 15000L;
    private long keepAliveTimeout = 60000L;
    private int keepAliveMaxRequestCount = 100;
    private long keepAliveConnectTime = 0L;
    private int keepAliveCount = 0;
    private long nrOfRequests = 0L;
    private long totalBytes = 0L;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$SocketSender;

    private synchronized void addStats(int length) {
        ++this.nrOfRequests;
        this.totalBytes += (long)length;
        if (log.isDebugEnabled() && this.nrOfRequests % 100L == 0L) {
            log.debug((Object)("Send stats from " + this.getAddress().getHostAddress() + ":" + this.getPort() + "Nr of bytes sent=" + this.totalBytes + " over " + this.nrOfRequests + " ==" + this.totalBytes / this.nrOfRequests + " bytes/request"));
        }
    }

    public long getNrOfRequests() {
        return this.nrOfRequests;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public SocketSender(InetAddress host, int port) {
        this.address = host;
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public void connect() throws IOException {
        this.sc = new Socket(this.getAddress(), this.getPort());
        this.sc.setSoTimeout((int)this.ackTimeout);
        this.isSocketConnected = true;
        this.keepAliveCount = 0;
        this.keepAliveConnectTime = System.currentTimeMillis();
    }

    public void disconnect() {
        try {
            this.sc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isSocketConnected = false;
    }

    public boolean isConnected() {
        return this.isSocketConnected;
    }

    public void checkIfDisconnect() {
        long ctime = System.currentTimeMillis() - this.keepAliveConnectTime;
        if (ctime > this.keepAliveTimeout || this.keepAliveCount >= this.keepAliveMaxRequestCount) {
            this.disconnect();
        }
    }

    public void setAckTimeout(long timeout) {
        this.ackTimeout = timeout;
    }

    public long getAckTimeout() {
        return this.ackTimeout;
    }

    public synchronized void sendMessage(String sessionId, byte[] data) throws IOException {
        this.checkIfDisconnect();
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            this.sc.getOutputStream().write(data);
            this.sc.getOutputStream().flush();
            this.waitForAck(this.ackTimeout);
        }
        catch (IOException x) {
            this.disconnect();
            this.connect();
            this.sc.getOutputStream().write(data);
            this.sc.getOutputStream().flush();
            this.waitForAck(this.ackTimeout);
        }
        ++this.keepAliveCount;
        this.checkIfDisconnect();
        this.addStats(data.length);
    }

    private void waitForAck(long timeout) throws IOException {
        try {
            int i = this.sc.getInputStream().read();
            while (i != -1 && i != 3) {
                i = this.sc.getInputStream().read();
            }
        }
        catch (SocketTimeoutException x) {
            log.warn((Object)("Wasn't able to read acknowledgement from server[" + this.getAddress() + ":" + this.getPort() + "] in " + this.ackTimeout + " ms." + " Disconnecting socket, and trying again."));
            throw x;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("SocketSender[");
        buf.append(this.getAddress()).append(":").append(this.getPort()).append("]");
        return buf.toString();
    }

    public boolean isSuspect() {
        return this.suspect;
    }

    public boolean getSuspect() {
        return this.suspect;
    }

    public void setSuspect(boolean suspect) {
        this.suspect = suspect;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(long keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public int getKeepAliveMaxRequestCount() {
        return this.keepAliveMaxRequestCount;
    }

    public void setKeepAliveMaxRequestCount(int keepAliveMaxRequestCount) {
        this.keepAliveMaxRequestCount = keepAliveMaxRequestCount;
    }

    public long getKeepAliveConnectTime() {
        return this.keepAliveConnectTime;
    }

    public int getKeepAliveCount() {
        return this.keepAliveCount;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

