<?php
//
// +------------------------------------------------------------------------+
// | PEAR :: PHPUnit                                                        |
// +------------------------------------------------------------------------+
// | Copyright (c) 2002-2003 Sebastian Bergmann <sb@sebastian-bergmann.de>. |
// +------------------------------------------------------------------------+
// | This source file is subject to version 3.00 of the PHP License,        |
// | that is available at http://www.php.net/license/3_0.txt.               |
// | If you did not receive a copy of the PHP license and are unable to     |
// | obtain it through the world-wide-web, please send a note to            |
// | license@php.net so we can mail you a copy immediately.                 |
// +------------------------------------------------------------------------+
//
// $Id: TestImplementorTest.php,v 1.2 2003/06/13 08:52:00 sebastian Exp $
//

require_once 'PHPUnit/Framework/TestCase.php';
require_once 'PHPUnit/Framework/TestResult.php';

require_once 'PHPUnit/Tests/Framework/DoubleTestCase.php';
require_once 'PHPUnit/Tests/Framework/Success.php';

class PHPUnit_Tests_Framework_TestImplementorTest extends PHPUnit_Framework_TestCase {
    private $fTest;

    public function __construct() {
        $this->fTest = new PHPUnit_Tests_Framework_DoubleTestCase(
          new PHPUnit_Tests_Framework_Success
        );
    }

    public function testSuccessfulRun() {
        $result = new PHPUnit_Framework_TestResult;

        $this->fTest->run($result);

        $this->assertEquals($this->fTest->countTestCases(), $result->runCount());
        $this->assertEquals(0, $result->errorCount());
        $this->assertEquals(0, $result->failureCount());
    }
}

/*
 * vim600:  et sw=2 ts=2 fdm=marker
 * vim<600: et sw=2 ts=2
 */
?>
