function simple_gui001
   clear all; clc; close all;
   %  Create and hide the GUI as it is being constructed.
   f = figure('Visible','off','Position',[200,200,450,285]);
   
   %  Construct the components.
   hsurf = uicontrol('Style','pushbutton','String','Surf','Position',[315,220,70,25],'Callback',{@surfbutton_Callback});
   hmesh = uicontrol('Style','pushbutton','String','Mesh','Position',[315,180,70,25],'Callback',{@meshbutton_Callback});
   hcontour = uicontrol('Style','pushbutton','String','Countour','Position',[315,135,70,25],'Callback',{@contourbutton_Callback}); 
   htext = uicontrol('Style','text','String','Select Data','Position',[325,90,60,15]);
   hpopup = uicontrol('Style','popupmenu','String',{'Linier','Kuadrat','Pangkat 3'},'Position',[300,50,100,25],'Callback',{@popup_menu_Callback});
   harea = axes('Units','Pixels','Position',[50,60,200,185]); 
   align([hsurf,hmesh,hcontour,htext,hpopup],'Center','None');
   
   %peaks_data = peaks(20);
   %membrane_data = membrane;
   [x,y] = meshgrid(-8:.5:8);
   r = x + x*y + y; %sqrt(x.^2+y.^2) + eps;
   linier_data = r;
   kuadrat_data = r*r;
   pkt_3_data =  r*r*r; %sin(r)./r;
   
   current_data = linier_data;
   surf(current_data);
   movegui(f,'center')

   %Make the GUI visible.
   set(f,'Visible','on')

   function popup_menu_Callback(source,eventdata) 
      % Determine the selected data set.
      str = get(source, 'String');
      val = get(source,'Value');
      % Set current data to the selected data set.
      switch str{val};
      case 'Linier' % User selects Peaks.
         current_data = linier_data;
      case 'Kuadrat' % User selects Membrane.
         current_data = kuadrat_data;
      case 'Pangkat 3' % User selects Sinc.
         current_data = pkt_3_data;
      end
   end
  
   function surfbutton_Callback(source,eventdata) 
   % Display surf plot of the currently selected data.
      surf(current_data);
   end
 
   function meshbutton_Callback(source,eventdata) 
   % Display mesh plot of the currently selected data.
      mesh(current_data);
   end
 
   function contourbutton_Callback(source,eventdata) 
   % Display contour plot of the currently selected data.
      contour(current_data);
   end 


end
